package jp.crestmuse.cmx.inference.game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;

import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;
import jp.crestmuse.cmx.sound.TickTimer;

public class ChordPanel extends JPanel {

  private static final Color[] CHORD_COLOR = { Color.RED, Color.ORANGE,
      Color.YELLOW, Color.GREEN, Color.BLUE, new Color(35, 71, 148),
      new Color(167, 87, 168) };
  private static final int PANEL_WIDTH = 420;
  private static final int PANEL_HEIGHT = 580;
  private static final int TUBE_LENGTH = 120;
  private static final int CHORDLOG_NUM = 4;
  private static final int MOVE_LIMIT = 10;
  private int chordlogLength;
  private int tubeY;
  private int tubeWidth;
  private int targetX;
  private int currentX;
  private int currentY;
  private Color currentColor;
  private Color targetColor;
  private MusicLog[] chordLogs;
  private int chordLogTailIndex;
  private MusicRepresentation mr;
  private TickTimer timer;
  private int measureTick;
  private int prevTickInMeasure;

  public ChordPanel(MusicRepresentation mr, TickTimer timer) {
    this.mr = mr;
    this.timer = timer;
    setPreferredSize(new Dimension(PANEL_WIDTH, PANEL_HEIGHT));
    chordlogLength = PANEL_WIDTH / 7;
    tubeY = PANEL_HEIGHT - (TUBE_LENGTH + chordlogLength * CHORDLOG_NUM);
    tubeWidth = PANEL_WIDTH / 7;

    currentColor = targetColor = CHORD_COLOR[0];
    chordLogs = new MusicLog[CHORDLOG_NUM + 1];
    for (int i = 0; i < CHORDLOG_NUM + 1; i++)
      chordLogs[i] = new MusicLog();
    chordLogTailIndex = 0;
    measureTick = timer.getTicksPerBeat() * 4;
    prevTickInMeasure = 0;
  }

  public void update() {
    long tick = timer.getTickPosition();
    int tickInMeasure = (int) (tick % measureTick);

    // move chord log if new measure
    if (tickInMeasure < prevTickInMeasure) {
      MusicElement currentChord = mr
          .getMusicElement("chord", mr.getIndex(tick));
      int currentIndex = currentChord.getHighestProbIndex();
      chordLogs[chordLogTailIndex].init(getWidth() * currentIndex / 7,
          getHeight() - chordlogLength * (CHORDLOG_NUM + 1), chordlogLength,
          CHORD_COLOR[currentIndex]);
      chordLogTailIndex++;
      chordLogTailIndex %= (CHORDLOG_NUM + 1);
      for (MusicLog ml : chordLogs)
        ml.updateTargetY();
    }
    prevTickInMeasure = tickInMeasure;
    for (MusicLog ml : chordLogs)
      ml.update();

    // set target
    try {
      MusicElement nextChord = mr.getMusicElement("chord", mr.getIndex(tick
          + measureTick));
      if (nextChord.set()) {
        int highestIndex = nextChord.getHighestProbIndex();
        targetX = getWidth() * highestIndex / 7;
        targetColor = CHORD_COLOR[highestIndex];
      }
    } catch (ArrayIndexOutOfBoundsException e) {
    }

    // aim target
    currentX += Math.max(Math.min((targetX - currentX), MOVE_LIMIT),
        -MOVE_LIMIT);
    int red = currentColor.getRed()
    + Math.max(Math.min(targetColor.getRed() - currentColor.getRed(),
        MOVE_LIMIT), -MOVE_LIMIT);
    int green = currentColor.getGreen()
    + Math.max(Math.min(targetColor.getGreen() - currentColor.getGreen(),
        MOVE_LIMIT), -MOVE_LIMIT);
    int blue = currentColor.getBlue()
    + Math.max(Math.min(targetColor.getBlue() - currentColor.getBlue(),
        MOVE_LIMIT), -MOVE_LIMIT);
    currentColor = new Color(red, green, blue);

    // get y from mr and current tick
    currentY = tubeY * tickInMeasure / measureTick;
  }

  public void paint(Graphics g) {
    super.paint(g);
    g.setColor(currentColor);
    g.fillOval(currentX, currentY, chordlogLength, chordlogLength);
    for (MusicLog ml : chordLogs)
      ml.paint(g);
    for (int i = 0; i < 7; i++) {
      g.setColor(CHORD_COLOR[i]);
      g.fillRect(i * tubeWidth, tubeY, tubeWidth, TUBE_LENGTH);
    }
  }

}
