package jp.crestmuse.cmx.bayesband.inference;

import jp.crestmuse.cmx.inference.*;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;

public class ChordPrintCalculator implements Calculator {

  public void update(MusicRepresentation musRep, MusicElement me, int index) {
    MusicElement chord;
    try{
      chord = musRep.getMusicElement("chord", index + musRep.getDivision());
    }catch(ArrayIndexOutOfBoundsException e){
      return;
    }
    printChordLabels(chord, chord.getProbLength());
    System.err.print("|");
    for (int i = 0; i < chord.getProbLength(); i++) {
//      System.err.printf("%s: ", chord.getLabel(i));
      for (int k = 0; k < 10; k++)
        if (chord.getProb(i) > (double) k / 10)
          System.err.print("*");
        else
          System.err.print(" ");
      System.err.print("|");
    }
    System.err.println();
  }

  private void printChordLabels(MusicElement me, int n) {
    System.err.print("|");
    for (int i = 0; i < n; i++)
      System.err.printf("%-10s|", me.getLabel(i));
    System.err.println();
  }

}
