#!/bin/bash

echo "Thank you for downloading BayesianBand ver.0.21."
echo "This program uses Apache Xerces, Xalan and Commons Math, distributed "
echo "under Apache License 2.0, and Weka, distributed under GPL 2."
echo "For details, read separate text files."
echo ""

java=`which java`
while [ -L $java ]
do
  ls=(`ls -l $java`)
  java=${ls[${#ls[@]}-1]}
done

java_home=`dirname $java`/../
if [ -e $java_home/jre/lib/ext/ ]; then
  lib_dir=$java_home/jre/lib/ext/
elif [ -e $java_home/lib/ext/ ]; then
  lib_dir=$java_home/lib/ext/
else
  echo [ERROR] No Java JRE or JDK found.
  exit 1
fi

echo "Now I'll be starting to install the libraries. "
echo "The following files are copying to ${lib_dir}."
echo ./lib/*.jar
echo "In general, it is not necessary to copy these files "
echo "if the same files have already been copied."
echo "Be carefully if you overwrite existing files."
echo "It may unable other software to run."

cp -i ./lib/*.jar $lib_dir

echo "Finished."

