#!/bin/sh

INSTALL_DIR=/usr/local
PACKAGE_NAME=cmx
RELEASE_NAME=BayesianBand0.22_GPL
SYMLINK_NAME=bayesband
BIN_DIR=bin
BIN_NAME=bayesband

srcdir=$(cd $(dirname $0) && pwd)

mkdir -p $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME
cp -r $srcdir/* $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME/

cat <<EOF > $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME/$BIN_NAME
#!/bin/sh

${SYMLINK_NAME}_HOME=$INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME

myclasspath=\$${SYMLINK_NAME}_HOME/BayesianBand.jar
for jarfile in \$${SYMLINK_NAME}_HOME/lib/*.jar
do 
  myclasspath=\$myclasspath:\$jarfile
done
CLASSPATH=\$myclasspath:\$CLASSPATH
export CLASSPATH

java jp.crestmuse.cmx.bayesband.BayesianBand \$${SYMLINK_NAME}_HOME/contents/model.bif \$${SYMLINK_NAME}_HOME/contents/C.mid \$*
EOF

chmod +x $INSTALL_DIR/$PACKAGE_NAME/$RELEASE_NAME/$BIN_NAME
(cd $INSTALL_DIR/$PACKAGE_NAME ; ln -sf $RELEASE_NAME $SYMLINK_NAME)
mkdir -p $INSTALL_DIR/$BIN_DIR
ln -sf $INSTALL_DIR/$PACKAGE_NAME/$SYMLINK_NAME/$BIN_NAME \
  $INSTALL_DIR/$BIN_DIR/$BIN_NAME
