package jp.crestmuse.cmx.inference;

import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;

public class NaiveBassCalculator implements Calculator {

  private static final int BASE_NN = 36;
  private static final int[][] basslines = new int[][] { { 0, 4, 7, 0 },
      { 2, 0, -3, 2 }, { 4, -1, -5, 4 }, { -7, 0, 5, -7 }, { -5, 7, 2, -5 },
      { -3, -1, 0, -3 }, { -1, 0, 1, 2 } };

  public void update(MusicRepresentation musRep, MusicElement me, int index) {
    int currentChord = me.getHighestProbIndex();
    // MusicElement bass = musicRepresentation.getBassElement(index);
    MusicElement bass = musRep.getMusicElement("bass", index);
    for (int i = 0; i < 4; i++) {
      // bass = musicRepresentation.getBassElement(index + (i) * 2);
      bass = musRep.getMusicElement("bass", index + i * 2);
      bass.setEvidence(BASE_NN + basslines[currentChord][i]);
    }
  }

}
