package jp.crestmuse.cmx.inference;

import java.io.IOException;
import java.io.OutputStream;

import org.xml.sax.SAXException;

//import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;

import jp.crestmuse.cmx.amusaj.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;

//import jp.crestmuse.cmx.inference.MusicRepresentation.Type;

public class AccompanimentCalculator implements Calculator {

  //private MusicRepresentation musicRepresentation;
  private BayesNetWrapper bayesNet;
/*
  private double[][] startDistribution;
  private final double alpha = 1.0;
  private int[] N = new int[144];
  private int[][] n = new int[144][12];
  private int prevPrevNote = 0;
*/
  public AccompanimentCalculator(BayesNetWrapper bayesNet) {
    // this.musicRepresentation = mr;
    this.bayesNet = bayesNet;
    // 初期状態でのnextNoteの確率分布を保存
    //this.startDistribution = bayesNet.getDistribution(4);
  }

  /*
    public Type[] drivenBy() {
      return new Type[]{Type.Melody};
    }
  */
  public void update(MusicRepresentation musRep, MusicElement me, int index) {
    int measure = index / musRep.getDivision() + 1;
    if (measure == musRep.getMeasureNum())
      return;
    // 一つ前の小節の後ろと前のインデックス
    int tail = (measure - 1) * musRep.getDivision() - 1;
    int head = (measure - 2) * musRep.getDivision();
    String prevNote = "/";
    for (int i = index - 1; i > head && i >= 0; i--) {
      // MusicElement e = musicRepresentation.getMelodyElement(i);
      MusicElement e = musRep.getMusicElement("melody", i);
      if (!e.set())
        continue;
      prevNote = (e.getHighestProbIndex() % 12) + "";
      break;
    }
    String prevChord = "/";
    try {
      // MusicElement m = musicRepresentation.getChordElement(head);
      MusicElement m = musRep.getMusicElement("chord", head);
      prevChord = m.getLabel(m.getHighestProbIndex());
    } catch (ArrayIndexOutOfBoundsException e) {
    }
    // MusicElement m = musicRepresentation.getChordElement(tail + 1);
    MusicElement m = musRep.getMusicElement("chord", tail + 1);
    String currentChord = m.getLabel(m.getHighestProbIndex());
    String currentNote = (me.getHighestProbIndex() % 12) + "";
    bayesNet.setEvidence(0, prevNote);
    bayesNet.setEvidence(1, prevChord);
    bayesNet.setEvidence(2, currentNote);
    bayesNet.setEvidence(3, currentChord);
    bayesNet.update();
    // 予測したnextNoteをMusicRepresentationに書き込む
    // MusicElement nextNote = musicRepresentation.getMelodyElement(index + 1);
    MusicElement nextNote = musRep.getMusicElement("melody",
        index + 1);
    for (int i = 0; i < bayesNet.getMargin(4).length; i++) {
      nextNote.setProb(i, bayesNet.getMargin(4)[i]);
    }
    // int highestIndex = bayesNet.getHighestMarginIndex(5);
    // String nextChord = bayesNet.getValueName(5, highestIndex);
    int nextIndex = measure * musRep.getDivision();
    // MusicElement chord = musicRepresentation.getChordElement(nextIndex);
    MusicElement chord = musRep
        .getMusicElement("chord", nextIndex);
    // musicRepresentation.update(Type.Chord, chord, nextIndex);
    double[] margins = bayesNet.getMargin(5);
    printChordLabels(chord, margins.length);
    System.err.print("|");
    for (int i = 0; i < margins.length; i++) {
      chord.setProb(i, margins[i]);
      for (int k = 0; k < 10; k++)
        if (margins[i] > (double) k / 10)
          System.err.print("*");
        else
          System.err.print(" ");
      System.err.print("|");
    }
    System.err.println();
    musRep.update("chord", nextIndex);
    // 確率テーブルを更新する
    /*
    if(!prevNote.equals("/")){
      int pNote = Integer.parseInt(prevNote);
      int cNote = Integer.parseInt(currentNote);
      int ind = pNote*12 + prevPrevNote;
      N[ind]++;
      n[ind][cNote]++;
      double p0 = startDistribution[ind][cNote];
      double weight = (p0 + alpha*Math.log(N[ind])*n[ind][cNote]/N[ind])/(1 + alpha*Math.log(N[ind]));
      DiscreteEstimatorBayes deb = (DiscreteEstimatorBayes)bayesNet.getDistribution()[4][ind];
      deb.addValue(cNote, weight - deb.getCount(cNote));
      prevPrevNote = pNote;
    }
    */

    // Prediction of the next of the next chord
    // tantative comment out because NaiveVoicingCalculator is used
    /*
    // 次の次のコードを予測
    if (measure >= musicRepresentation.getMeasureNum() - 1)
      return;
    bayesNet.setEvidence(0, currentNote);
    bayesNet.setEvidence(1, currentChord);
    bayesNet.setEvidence(2, "/");
    bayesNet.setEvidence(3, nextChord);
    bayesNet.update();
    highestIndex = bayesNet.getHighestMarginIndex(5);
    nextChord = bayesNet.getValueName(5, highestIndex);
    //ce = new ChordElement(bayesNet.getHighestMarginName(5));
    nextIndex = (measure + 1) * musicRepresentation.getDivision();
    chord = musicRepresentation.addChordElement(nextIndex);
    margins = bayesNet.getMargin(5);
    printChordLabels(chord, margins.length);
    System.err.print("|");
    for(int i=0; i<margins.length; i++) {
    chord.setProb(i, margins[i]);
    System.err.printf("%7s: ", chord.getLabel(i));
    for (int k = 0; k < 10; k++)
    if (margins[i] > (double)k / 10) 
    System.err.print("*");
    else
    System.err.print(" ");
    System.err.print("|");
    }
    System.err.println();
    */
    // musicRepresentation.setPredict(1, (measure + 1) *
    // musicRepresentation.getDivision(), ce);
    // }
  }

  public void writeBif(OutputStream out) throws IOException, SAXException {
    bayesNet.write(out);
  }

  private void printChordLabels(MusicElement me, int n) {
    System.err.print("|");
    for (int i = 0; i < n; i++)
      System.err.printf("%-10s|", me.getLabel(i));
    System.err.println();
  }

}
