package jp.crestmuse.cmx;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;

import jp.crestmuse.cmx.amusaj.filewrappers.*;
import jp.crestmuse.cmx.amusaj.sp.*;
import jp.crestmuse.cmx.inference.BayesianCalculator;
import jp.crestmuse.cmx.inference.BayesianMapping;
import jp.crestmuse.cmx.inference.ChordPrintCalculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.AccompanimentGenerator;
import jp.crestmuse.cmx.inference.MelodyWriter;
import jp.crestmuse.cmx.inference.NaiveVoicingCalculator;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;
import jp.crestmuse.cmx.sound.SequencerManager;
import jp.crestmuse.cmx.sound.VirtualKeyboard;

public class AutoAccompanimentSystem {

  static MusicRepresentation mr;

  public static void main(String[] args) {
    // init gui
    // GUI.getInstance();
    try {
      int length = 8;
      String modelFile = args[0];
      String chordMIDIFile = args[1];
      String firstChord = "C";
      String inputSMF = null;
      boolean writeLog = false;
      boolean useVirtualKeyboard = false;
      for (int i = 2; i < args.length; i++) {
        if (args[i].equals("-length")) {
          length = Integer.parseInt(args[i + 1]);
          i++;
        } else if (args[i].equals("-start")) {
          firstChord = args[i + 1];
          i++;
        } else if (args[i].equals("-smf")) {
          inputSMF = args[i + 1];
          i++;
        } else if (args[i].equals("-v")) {
          writeLog = true;
        } else if (args[i].equals("-vkb")) {
          useVirtualKeyboard = true;
        }
      }

      // MusicRepresentation周り
      mr = new MusicRepresentation(length, 8);
      mr.addMusicLayer("melody", 12);
      mr.addMusicLayer("chord", new String[]{ "C", "Dm", "Em", "F", "G", "Am", "Bm(b5)" }, 8);
      mr.addMusicLayer("bass", 128, 2);
      mr.addMusicLayer("voicingHigh", 128, 8);
      mr.addMusicLayer("voicingMidHigh", 128, 8);
      mr.addMusicLayer("voicingMidLow", 128, 8);
      mr.addMusicLayer("voicingLow", 128, 8);
      /*
      mr.setTiedChordLength(8);
      mr.setTiedVoicingLength(8);
      mr.setTiedBassLength(2);
      */
      // AccompanimentCalculator ac = new AccompanimentCalculator(mr, new BayesNetWrapper(modelFile));
      BayesianCalculator ac = new BayesianCalculator(new BayesNetWrapper(modelFile));

      ac.addReadMapping(
        new BayesianMapping("melody", -1, BayesianMapping.SET_ONLY, 0));
      ac.addReadMapping
	  (new BayesianMapping("chord", -1, BayesianMapping.BY_TIED_LENGTH, 1));
	    //ac.addReadMapping
	    //(new BayesianMapping("chord", -2, BayesianMapping.MEASURE_HEAD, 1));
      ac.addReadMapping(
        new BayesianMapping("melody", 0, BayesianMapping.NORMAL, 2));
      ac.addReadMapping(
        new BayesianMapping("chord", 0, BayesianMapping.NORMAL, 3));
      //      ac.addReadMapping
      //	  (new BayesianMapping("chord", -1, BayesianMapping.MEASURE_HEAD, 3));
      ac.addWriteMapping(
        new BayesianMapping("melody", 1, BayesianMapping.NORMAL, 4));
      ac.addWriteMapping(
        new BayesianMapping("chord", 1, BayesianMapping.BY_TIED_LENGTH, 5));

/*

      ac.addReadMapping(new BayesianMapping("melody", 0){
        public int getMusicRepresentationIndex(MusicRepresentation musRep, int source) {
          int measure = source / musRep.getDivision() + 1;
          int head = (measure - 2) * musRep.getDivision();
          for (int i = source - 1; i > head && i >= 0; i--) {
            MusicElement e = musRep.getMusicElement("melody", i);
            if (!e.set()) continue;
            return i;
          }
          return 0;
        }
      });
      ac.addReadMapping(new BayesianMapping("chord", 1){
        public int getMusicRepresentationIndex(MusicRepresentation musRep, int source) {
          int measure = source / musRep.getDivision() + 1;
          int head = (measure - 2) * musRep.getDivision();
          return Math.max(0, head);
        }
      });
      ac.addReadMapping(new BayesianMapping("melody", 2){});
      ac.addReadMapping(new BayesianMapping("chord", 3){
        public int getMusicRepresentationIndex(MusicRepresentation musRep, int source) {
          int measure = source / musRep.getDivision() + 1;
          int tail = (measure - 1) * musRep.getDivision();
          return tail;
        }
      });
      ac.addWriteMapping(new BayesianMapping("melody", 4){
        public int getMusicRepresentationIndex(MusicRepresentation musRep, int source) {
          return source + 1;
        }
      });
      ac.addWriteMapping(new BayesianMapping("chord", 5, true){
        public int getMusicRepresentationIndex(MusicRepresentation musRep, int source) {
          int measure = source / musRep.getDivision() + 1;
          return measure * musRep.getDivision();
        }
//        public boolean update() {
//          return true;
//        }
      });
*/
      // NaiveBassCalculator bc = new NaiveBassCalculator(mr);
      NaiveVoicingCalculator vc = new NaiveVoicingCalculator();
      mr.addCalculator("melody", ac);
      // mr.addCalculator(bc);
      mr.addCalculator("chord", vc);
      mr.addCalculator("melody", new ChordPrintCalculator());
      // MusicElement chord = mr.getChordElement(0);
      MusicElement chord = mr.getMusicElement("chord", 0);
      chord.setProb(chord.indexOf(firstChord), 1.0);
      // mr.update(Type.Chord, chord, 0);
      mr.update("chord", 0);
      // mr.setPredict(1, 0, new ChordElement("C"));

      // SP周り
      MidiInputModule mi;
      Sequencer seqr = null;
      if (inputSMF != null) {
        seqr = MidiSystem.getSequencer(false);
        seqr.setSequence(MidiSystem.getSequence(new File(inputSMF)));
        mi = new MidiInputModule(seqr);
      } else if (useVirtualKeyboard) {
        mi = new MidiInputModule(new VirtualKeyboard());
      } else {
        mi = new MidiInputModule(getMidiDevice(true));
      }
      SPExecutor sp = new SPExecutor();
      // MidiInputModule mi = new
      // MidiInputModule(MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[0]));
      MelodyWriter mrm = new MelodyWriter(mr,
          writeLog);
      MidiDevice device = getMidiDevice(false);
      device.open();
      MidiOutputModule mo = new MidiOutputModule(device.getReceiver());

      // SequencerManager周り
      SequencerManager sm = new SequencerManager(device.getReceiver());
      if (inputSMF != null)
        seqr.setMasterSyncMode(sm.getSequencer().getMasterSyncMode());
      AccompanimentGenerator mrg = new AccompanimentGenerator(mr, chordMIDIFile);
      sm.addGeneratable(mrg);

      // MusicRepresentationViewer mrv = new MusicRepresentationViewer();

      mi.setTickTimer(sm);
      SPSpreadModule towway =
        new SPSpreadModule(MidiEventWithTicktime.class, 2);
      sp.addSPModule(mi);
      sp.addSPModule(towway);
      sp.addSPModule(mo);
      sp.addSPModule(mrm);
      // sp.addSPModule(mrv);
      sp.connect(mi, 0, towway, 0);
      sp.connect(towway, 0, mo, 0);
      sp.connect(towway, 1, mrm, 0);
      // sp.connect(mrm, 0, mrv, 0);

      // 起動
      sp.start();
      sm.start();
      if (inputSMF != null)
        seqr.start();

      // 終了
      System.err.println("press button to exit...");
      System.in.read();
      sm.stop();
      sp.stop();
      device.close();
      // ac.writeBif(System.out);
    } catch (Exception e) {
      e.printStackTrace();
    }
    System.exit(0);
  }

  public static MidiDevice getMidiDevice(boolean trans) {
    MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
    MidiDevice device = null;

    for (int i = 0; i < info.length; i++) {
      try {
        device = MidiSystem.getMidiDevice(info[i]);
        if (trans && device.getMaxTransmitters() == 0)
          continue;
        if (!trans && device.getMaxReceivers() == 0)
          continue;
        System.err.println("*** " + i + " ***");
        System.err.println("  Description:" + info[i].getDescription());
        System.err.println("  Name:" + info[i].getName());
        System.err.println("  Vendor:" + info[i].getVendor());
        System.err.println();
      } catch (MidiUnavailableException e) {
        e.printStackTrace();
      }
    }

    try {
      BufferedReader r = new BufferedReader(new InputStreamReader(System.in), 1);
      if (trans)
        System.err.print("Using Input Device Number: ");
      else
        System.err.print("Using Output Device Number: ");
      String s = r.readLine();
      device = MidiSystem.getMidiDevice(info[Integer.parseInt(s)]);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return device;
  }
  /*
    private static class MusicRepresentationViewer extends
        SPModule<SPDummyObject, SPDummyObject> {
      public void execute(List<QueueReader<SPDummyObject>> src,
          List<TimeSeriesCompatible<SPDummyObject>> dest) {

      }
      public int getInputChannels() {
        return 1;
      }
      public int getOutputChannels() {
        return 0;
      }
    }
  */
}
