package jp.crestmuse.cmx.inference;

import java.util.HashMap;
import java.util.Map;

import jp.crestmuse.cmx.amusaj.commands.ChordConverter;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.MusicRepresentation.MusicElement;
import jp.crestmuse.cmx.inference.MusicRepresentation.Type;

public class NaiveBassCalculator implements Calculator {

  private MusicRepresentation musicRepresentation;

    private static final int BASE_NN = 36;

    private static final int[][] basslines = 
	new int[][]{{0, 4, 7, 0}, {2, 0, -3, 2}, {4, -1, -5, 4}, 
		    {-7, 0, 5, -7}, {-5, 7, 2, -5}, {-3, -1, 0, -3}, 
		    {-1, 0, 1, 2}};

  public NaiveBassCalculator(MusicRepresentation mr) {
    musicRepresentation = mr;
  }

  public Type[] drivenBy() {
    return new Type[]{Type.Chord};
  }

  public void update(MusicElement me, int index) {
      int currentChord = me.getHighestProbIndex();
    MusicElement bass = musicRepresentation.addBassElement(index);
    for (int i = 0; i < 4; i++) {
	bass = musicRepresentation.addBassElement(index + (i) * 2);
	bass.setEvidence(BASE_NN + basslines[currentChord][i]);
    }
  }

}
