/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.RealVectorFormat;
import org.apache.commons.math.util.MathUtils;

public class ArrayRealVector
implements RealVector,
Serializable {
    private static final long serialVersionUID = -1097961340710804027L;
    private static final RealVectorFormat DEFAULT_FORMAT = RealVectorFormat.getInstance();
    protected double[] data;

    public ArrayRealVector() {
        this.data = new double[0];
    }

    public ArrayRealVector(int size) {
        this.data = new double[size];
    }

    public ArrayRealVector(int size, double preset) {
        this.data = new double[size];
        Arrays.fill(this.data, preset);
    }

    public ArrayRealVector(double[] d) {
        this.data = (double[])d.clone();
    }

    public ArrayRealVector(double[] d, boolean copyArray) throws NullPointerException, IllegalArgumentException {
        if (d == null) {
            throw new NullPointerException();
        }
        if (d.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException("vector must have at least one element", new Object[0]);
        }
        this.data = copyArray ? (double[])d.clone() : d;
    }

    public ArrayRealVector(double[] d, int pos, int size) {
        if (d.length < pos + size) {
            throw MathRuntimeException.createIllegalArgumentException("position {0} and size {1} don't fit to the size of the input array {2}", pos, size, d.length);
        }
        this.data = new double[size];
        System.arraycopy(d, pos, this.data, 0, size);
    }

    public ArrayRealVector(Double[] d) {
        this.data = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            this.data[i] = d[i];
        }
    }

    public ArrayRealVector(Double[] d, int pos, int size) {
        if (d.length < pos + size) {
            throw MathRuntimeException.createIllegalArgumentException("position {0} and size {1} don't fit to the size of the input array {2}", pos, size, d.length);
        }
        this.data = new double[size];
        for (int i = pos; i < pos + size; ++i) {
            this.data[i - pos] = d[i];
        }
    }

    public ArrayRealVector(RealVector v) {
        this.data = new double[v.getDimension()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = v.getEntry(i);
        }
    }

    public ArrayRealVector(ArrayRealVector v) {
        this.data = (double[])v.data.clone();
    }

    public ArrayRealVector(ArrayRealVector v, boolean deep) {
        this.data = deep ? (double[])v.data.clone() : v.data;
    }

    public ArrayRealVector(ArrayRealVector v1, ArrayRealVector v2) {
        this.data = new double[v1.data.length + v2.data.length];
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2.data, 0, this.data, v1.data.length, v2.data.length);
    }

    public ArrayRealVector(ArrayRealVector v1, double[] v2) {
        this.data = new double[v1.data.length + v2.length];
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2, 0, this.data, v1.data.length, v2.length);
    }

    public ArrayRealVector(double[] v1, ArrayRealVector v2) {
        this.data = new double[v1.length + v2.data.length];
        System.arraycopy(v1, 0, this.data, 0, v1.length);
        System.arraycopy(v2.data, 0, this.data, v1.length, v2.data.length);
    }

    public ArrayRealVector(double[] v1, double[] v2) {
        this.data = new double[v1.length + v2.length];
        System.arraycopy(v1, 0, this.data, 0, v1.length);
        System.arraycopy(v2, 0, this.data, v1.length, v2.length);
    }

    public RealVector copy() {
        return new ArrayRealVector(this, true);
    }

    public RealVector add(RealVector v) throws IllegalArgumentException {
        try {
            return this.add((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double[] out = new double[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                out[i] = this.data[i] + v.getEntry(i);
            }
            return new ArrayRealVector(out);
        }
    }

    public RealVector add(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] + v[i];
        }
        return new ArrayRealVector(out);
    }

    public ArrayRealVector add(ArrayRealVector v) throws IllegalArgumentException {
        return (ArrayRealVector)this.add(v.data);
    }

    public RealVector subtract(RealVector v) throws IllegalArgumentException {
        try {
            return this.subtract((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double[] out = new double[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                out[i] = this.data[i] - v.getEntry(i);
            }
            return new ArrayRealVector(out);
        }
    }

    public RealVector subtract(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] - v[i];
        }
        return new ArrayRealVector(out);
    }

    public ArrayRealVector subtract(ArrayRealVector v) throws IllegalArgumentException {
        return (ArrayRealVector)this.subtract(v.data);
    }

    public RealVector mapAdd(double d) {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] + d;
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapAddToSelf(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] + d;
        }
        return this;
    }

    public RealVector mapSubtract(double d) {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] - d;
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapSubtractToSelf(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] - d;
        }
        return this;
    }

    public RealVector mapMultiply(double d) {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] * d;
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapMultiplyToSelf(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] * d;
        }
        return this;
    }

    public RealVector mapDivide(double d) {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] / d;
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapDivideToSelf(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] / d;
        }
        return this;
    }

    public RealVector mapPow(double d) {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.pow(this.data[i], d);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapPowToSelf(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.pow(this.data[i], d);
        }
        return this;
    }

    public RealVector mapExp() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.exp(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapExpToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.exp(this.data[i]);
        }
        return this;
    }

    public RealVector mapExpm1() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.expm1(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapExpm1ToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.expm1(this.data[i]);
        }
        return this;
    }

    public RealVector mapLog() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.log(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapLogToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.log(this.data[i]);
        }
        return this;
    }

    public RealVector mapLog10() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.log10(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapLog10ToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.log10(this.data[i]);
        }
        return this;
    }

    public RealVector mapLog1p() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.log1p(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapLog1pToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.log1p(this.data[i]);
        }
        return this;
    }

    public RealVector mapCosh() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.cosh(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapCoshToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.cosh(this.data[i]);
        }
        return this;
    }

    public RealVector mapSinh() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.sinh(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapSinhToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.sinh(this.data[i]);
        }
        return this;
    }

    public RealVector mapTanh() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.tanh(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapTanhToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.tanh(this.data[i]);
        }
        return this;
    }

    public RealVector mapCos() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.cos(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapCosToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.cos(this.data[i]);
        }
        return this;
    }

    public RealVector mapSin() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.sin(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapSinToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.sin(this.data[i]);
        }
        return this;
    }

    public RealVector mapTan() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.tan(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapTanToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.tan(this.data[i]);
        }
        return this;
    }

    public RealVector mapAcos() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.acos(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapAcosToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.acos(this.data[i]);
        }
        return this;
    }

    public RealVector mapAsin() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.asin(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapAsinToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.asin(this.data[i]);
        }
        return this;
    }

    public RealVector mapAtan() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.atan(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapAtanToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.atan(this.data[i]);
        }
        return this;
    }

    public RealVector mapInv() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = 1.0 / this.data[i];
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapInvToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 1.0 / this.data[i];
        }
        return this;
    }

    public RealVector mapAbs() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.abs(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapAbsToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.abs(this.data[i]);
        }
        return this;
    }

    public RealVector mapSqrt() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.sqrt(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapSqrtToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.sqrt(this.data[i]);
        }
        return this;
    }

    public RealVector mapCbrt() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.cbrt(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapCbrtToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.cbrt(this.data[i]);
        }
        return this;
    }

    public RealVector mapCeil() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.ceil(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapCeilToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.ceil(this.data[i]);
        }
        return this;
    }

    public RealVector mapFloor() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.floor(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapFloorToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.floor(this.data[i]);
        }
        return this;
    }

    public RealVector mapRint() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.rint(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapRintToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.rint(this.data[i]);
        }
        return this;
    }

    public RealVector mapSignum() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.signum(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapSignumToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.signum(this.data[i]);
        }
        return this;
    }

    public RealVector mapUlp() {
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = Math.ulp(this.data[i]);
        }
        return new ArrayRealVector(out);
    }

    public RealVector mapUlpToSelf() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.ulp(this.data[i]);
        }
        return this;
    }

    public RealVector ebeMultiply(RealVector v) throws IllegalArgumentException {
        try {
            return this.ebeMultiply((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double[] out = new double[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                out[i] = this.data[i] * v.getEntry(i);
            }
            return new ArrayRealVector(out);
        }
    }

    public RealVector ebeMultiply(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] * v[i];
        }
        return new ArrayRealVector(out);
    }

    public ArrayRealVector ebeMultiply(ArrayRealVector v) throws IllegalArgumentException {
        return (ArrayRealVector)this.ebeMultiply(v.data);
    }

    public RealVector ebeDivide(RealVector v) throws IllegalArgumentException {
        try {
            return this.ebeDivide((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double[] out = new double[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                out[i] = this.data[i] / v.getEntry(i);
            }
            return new ArrayRealVector(out);
        }
    }

    public RealVector ebeDivide(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double[] out = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.data[i] / v[i];
        }
        return new ArrayRealVector(out);
    }

    public ArrayRealVector ebeDivide(ArrayRealVector v) throws IllegalArgumentException {
        return (ArrayRealVector)this.ebeDivide(v.data);
    }

    public double[] getData() {
        return (double[])this.data.clone();
    }

    public double[] getDataRef() {
        return this.data;
    }

    public double dotProduct(RealVector v) throws IllegalArgumentException {
        try {
            return this.dotProduct((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double dot = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                dot += this.data[i] * v.getEntry(i);
            }
            return dot;
        }
    }

    public double dotProduct(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double dot = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            dot += this.data[i] * v[i];
        }
        return dot;
    }

    public double dotProduct(ArrayRealVector v) throws IllegalArgumentException {
        return this.dotProduct(v.data);
    }

    public double getNorm() {
        double sum = 0.0;
        for (double a : this.data) {
            sum += a * a;
        }
        return Math.sqrt(sum);
    }

    public double getL1Norm() {
        double sum = 0.0;
        for (double a : this.data) {
            sum += Math.abs(a);
        }
        return sum;
    }

    public double getLInfNorm() {
        double max = 0.0;
        for (double a : this.data) {
            max += Math.max(max, Math.abs(a));
        }
        return max;
    }

    public double getDistance(RealVector v) throws IllegalArgumentException {
        try {
            return this.getDistance((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double sum = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                double delta = this.data[i] - v.getEntry(i);
                sum += delta * delta;
            }
            return Math.sqrt(sum);
        }
    }

    public double getDistance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double sum = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double delta = this.data[i] - v[i];
            sum += delta * delta;
        }
        return Math.sqrt(sum);
    }

    public double getDistance(ArrayRealVector v) throws IllegalArgumentException {
        return this.getDistance(v.data);
    }

    public double getL1Distance(RealVector v) throws IllegalArgumentException {
        try {
            return this.getL1Distance((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double sum = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                double delta = this.data[i] - v.getEntry(i);
                sum += Math.abs(delta);
            }
            return sum;
        }
    }

    public double getL1Distance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double sum = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double delta = this.data[i] - v[i];
            sum += Math.abs(delta);
        }
        return sum;
    }

    public double getL1Distance(ArrayRealVector v) throws IllegalArgumentException {
        return this.getL1Distance(v.data);
    }

    public double getLInfDistance(RealVector v) throws IllegalArgumentException {
        try {
            return this.getLInfDistance((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            double max = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                double delta = this.data[i] - v.getEntry(i);
                max = Math.max(max, Math.abs(delta));
            }
            return max;
        }
    }

    public double getLInfDistance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double max = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double delta = this.data[i] - v[i];
            max = Math.max(max, Math.abs(delta));
        }
        return max;
    }

    public double getLInfDistance(ArrayRealVector v) throws IllegalArgumentException {
        return this.getLInfDistance(v.data);
    }

    public RealVector unitVector() throws ArithmeticException {
        double norm = this.getNorm();
        if (norm == 0.0) {
            throw MathRuntimeException.createArithmeticException("zero norm", new Object[0]);
        }
        return this.mapDivide(this.getNorm());
    }

    public void unitize() throws ArithmeticException {
        double norm = this.getNorm();
        if (norm == 0.0) {
            throw MathRuntimeException.createArithmeticException("cannot normalize a zero norm vector", new Object[0]);
        }
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] / norm;
        }
    }

    public RealVector projection(RealVector v) {
        return v.mapMultiply(this.dotProduct(v) / v.dotProduct(v));
    }

    public RealVector projection(double[] v) {
        return this.projection(new ArrayRealVector(v, false));
    }

    public ArrayRealVector projection(ArrayRealVector v) {
        return (ArrayRealVector)v.mapMultiply(this.dotProduct(v) / v.dotProduct(v));
    }

    public RealMatrix outerProduct(RealVector v) throws IllegalArgumentException {
        try {
            return this.outerProduct((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            int m = this.data.length;
            RealMatrix out = MatrixUtils.createRealMatrix(m, m);
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 0; j < this.data.length; ++j) {
                    out.setEntry(i, j, this.data[i] * v.getEntry(j));
                }
            }
            return out;
        }
    }

    public RealMatrix outerProduct(ArrayRealVector v) throws IllegalArgumentException {
        return this.outerProduct(v.data);
    }

    public RealMatrix outerProduct(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        int m = this.data.length;
        RealMatrix out = MatrixUtils.createRealMatrix(m, m);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                out.setEntry(i, j, this.data[i] * v[j]);
            }
        }
        return out;
    }

    public double getEntry(int index) throws MatrixIndexException {
        return this.data[index];
    }

    public int getDimension() {
        return this.data.length;
    }

    public RealVector append(RealVector v) {
        try {
            return this.append((ArrayRealVector)v);
        }
        catch (ClassCastException cce) {
            return new ArrayRealVector(this, new ArrayRealVector(v));
        }
    }

    public ArrayRealVector append(ArrayRealVector v) {
        return new ArrayRealVector(this, v);
    }

    public RealVector append(double in) {
        double[] out = new double[this.data.length + 1];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        out[this.data.length] = in;
        return new ArrayRealVector(out);
    }

    public RealVector append(double[] in) {
        return new ArrayRealVector(this, in);
    }

    public RealVector getSubVector(int index, int n) {
        ArrayRealVector out = new ArrayRealVector(n);
        try {
            System.arraycopy(this.data, index, out.data, 0, n);
        }
        catch (IndexOutOfBoundsException e) {
            this.checkIndex(index);
            this.checkIndex(index + n - 1);
        }
        return out;
    }

    public void setEntry(int index, double value) {
        try {
            this.data[index] = value;
        }
        catch (IndexOutOfBoundsException e) {
            this.checkIndex(index);
        }
    }

    public void setSubVector(int index, RealVector v) {
        try {
            try {
                this.set(index, (ArrayRealVector)v);
            }
            catch (ClassCastException cce) {
                for (int i = index; i < index + v.getDimension(); ++i) {
                    this.data[i] = v.getEntry(i - index);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.checkIndex(index);
            this.checkIndex(index + v.getDimension() - 1);
        }
    }

    public void setSubVector(int index, double[] v) {
        try {
            System.arraycopy(v, 0, this.data, index, v.length);
        }
        catch (IndexOutOfBoundsException e) {
            this.checkIndex(index);
            this.checkIndex(index + v.length - 1);
        }
    }

    public void set(int index, ArrayRealVector v) throws MatrixIndexException {
        this.setSubVector(index, v.data);
    }

    public void set(double value) {
        Arrays.fill(this.data, value);
    }

    public double[] toArray() {
        return (double[])this.data.clone();
    }

    public String toString() {
        return DEFAULT_FORMAT.format(this);
    }

    protected void checkVectorDimensions(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
    }

    protected void checkVectorDimensions(int n) throws IllegalArgumentException {
        if (this.data.length != n) {
            throw MathRuntimeException.createIllegalArgumentException("vector length mismatch: got {0} but expected {1}", this.data.length, n);
        }
    }

    public boolean isNaN() {
        for (double v : this.data) {
            if (!Double.isNaN(v)) continue;
            return true;
        }
        return false;
    }

    public boolean isInfinite() {
        if (this.isNaN()) {
            return false;
        }
        for (double v : this.data) {
            if (!Double.isInfinite(v)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            RealVector rhs = (RealVector)other;
            if (this.data.length != rhs.getDimension()) {
                return false;
            }
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == rhs.getEntry(i)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 9;
        }
        return MathUtils.hash(this.data);
    }

    private void checkIndex(int index) throws MatrixIndexException {
        if (index < 0 || index >= this.getDimension()) {
            throw new MatrixIndexException("index {0} out of allowed range [{1}, {2}]", index, 0, this.getDimension() - 1);
        }
    }
}

