/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.handlers.NoteHandlerPartwise;
import jp.crestmuse.cmx.misc.MutableNote;
import jp.crestmuse.cmx.misc.TreeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledDeviation {
    public static int TICKS_PER_BEAT = 480;
    private int BASE_DYNAMICS = 100;
    private int TEMPO = 72;
    private Sequence sequence = new Sequence(0.0f, TICKS_PER_BEAT);
    private ArrayList<DeviatedNote> deviatedNotes = new ArrayList();
    private TreeMap<Integer, Integer> ticks2tempo = new TreeMap();
    private TreeMap<Integer, Integer> ticks2msec = new TreeMap();

    public CompiledDeviation(final DeviationInstanceWrapper deviationInstanceWrapper) throws IOException, InvalidMidiDataException {
        this.processNonPartwiseControls(deviationInstanceWrapper);
        this.calcMsecs();
        final HashMap hashMap = new HashMap();
        deviationInstanceWrapper.getTargetMusicXML().processNotePartwise(new NoteHandlerPartwise(){
            private Track track;

            public void beginPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
                this.track = CompiledDeviation.this.sequence.createTrack();
                hashMap.put(part.id(), this.track);
            }

            public void beginMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void endMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void endPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
            }

            public void processMusicData(MusicXMLWrapper.MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
                if (!(musicData instanceof MusicXMLWrapper.Note)) {
                    return;
                }
                MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                if (note.rest() || "none".equals(note.notehead()) || note.containsTieType("stop")) {
                    return;
                }
                try {
                    DeviationInstanceWrapper.ChordDeviation chordDeviation;
                    if (deviationInstanceWrapper.getMissNote(note) != null) {
                        CompiledDeviation.this.deviatedNotes.add(new DeviatedNote(note, true, this.track));
                        return;
                    }
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 1.0;
                    double d4 = 1.0;
                    DeviationInstanceWrapper.NoteDeviation noteDeviation = deviationInstanceWrapper.getNoteDeviation(note);
                    if (noteDeviation != null) {
                        d += noteDeviation.attack();
                        d2 += noteDeviation.release();
                        d3 *= noteDeviation.dynamics();
                        d4 *= noteDeviation.endDynamics();
                    }
                    if ((chordDeviation = deviationInstanceWrapper.getChordDeviation(note)) != null) {
                        d += chordDeviation.attack();
                        d2 += chordDeviation.release();
                        d3 *= chordDeviation.dynamics();
                        d4 *= chordDeviation.endDynamics();
                    }
                    CompiledDeviation.this.deviatedNotes.add(new DeviatedNote(note, d, d2, d3, d4, false, this.track));
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    invalidMidiDataException.printStackTrace();
                }
            }
        });
        for (Map.Entry entry : hashMap.entrySet()) {
            this.processExtraNotes(deviationInstanceWrapper, (String)entry.getKey(), (Track)entry.getValue());
        }
    }

    private void processNonPartwiseControls(DeviationInstanceWrapper deviationInstanceWrapper) {
        Track track = this.sequence.createTrack();
        this.setTempo(0, track, this.TEMPO);
        TreeView<DeviationInstanceWrapper.Control> treeView = deviationInstanceWrapper.getNonPartwiseControlView();
        int n = this.addTempo(treeView.getRoot(), track, this.TEMPO);
        while (treeView.hasElementsAtNextTime()) {
            n = this.addTempo(treeView.getFirstElementAtNextTime(), track, n);
            while (treeView.hasMoreElementsAtSameTime()) {
                n = this.addTempo(treeView.getNextElementAtSameTime(), track, n);
            }
        }
    }

    private int addTempo(DeviationInstanceWrapper.Control control, Track track, int n) {
        int n2;
        if (control == null) {
            return n;
        }
        if (control.type().equals("tempo")) {
            n2 = n = (int)control.value();
        } else if (control.type().equals("tempo-deviation")) {
            n2 = (int)((double)n * control.value());
        } else {
            return n;
        }
        try {
            this.setTempo(control.timestamp(TICKS_PER_BEAT), track, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    private void setTempo(int n, Track track, int n2) {
        MetaMessage metaMessage = new MetaMessage();
        int n3 = 60000000 / n2;
        try {
            metaMessage.setMessage(81, new byte[]{(byte)(n3 / 65536), (byte)(n3 % 65536 / 256), (byte)(n3 % 256)}, 3);
            track.add(new MidiEvent(metaMessage, n));
            this.ticks2tempo.put(n, n2);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private void calcMsecs() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Map.Entry<Integer, Integer> entry : this.ticks2tempo.entrySet()) {
            n = (int)((double)n + (double)(entry.getKey() - n2) / (double)TICKS_PER_BEAT / (double)n3 * 60.0 * 1000.0);
            this.ticks2msec.put(entry.getKey(), n);
            n2 = entry.getKey();
            n3 = entry.getValue();
        }
    }

    private void processExtraNotes(DeviationInstanceWrapper deviationInstanceWrapper, String string, Track track) {
        TreeView<DeviationInstanceWrapper.ExtraNote> treeView = deviationInstanceWrapper.getExtraNoteView(string);
        this.addExtraNote(treeView.getRoot(), string, track);
        while (treeView.hasElementsAtNextTime()) {
            this.addExtraNote(treeView.getFirstElementAtNextTime(), string, track);
            while (treeView.hasMoreElementsAtSameTime()) {
                this.addExtraNote(treeView.getNextElementAtSameTime(), string, track);
            }
        }
    }

    private void addExtraNote(DeviationInstanceWrapper.ExtraNote extraNote, String string, Track track) {
        if (extraNote == null) {
            return;
        }
        try {
            int n = extraNote.timestamp(TICKS_PER_BEAT);
            int n2 = n + (int)(extraNote.duration() * (double)TICKS_PER_BEAT);
            this.deviatedNotes.add(new DeviatedNote(null, n, n2, extraNote.notenum(), 0.0, 0.0, extraNote.dynamics(), extraNote.endDynamics(), false, string, track));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public ArrayList<DeviatedNote> getDeviatedNotes() {
        return this.deviatedNotes;
    }

    public Map<Integer, Integer> getTicks2Tempo() {
        return this.ticks2tempo;
    }

    public DeviationInstanceWrapper calcDeviation() throws InvalidFileTypeException {
        DeviationInstanceWrapper deviationInstanceWrapper = (DeviationInstanceWrapper)CMXFileWrapper.createDocument("deviation");
        DeviationDataSet deviationDataSet = deviationInstanceWrapper.createDeviationDataSet();
        double d = 0.0;
        Iterator<Object> iterator = this.ticks2tempo.values().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            d += (double)n;
        }
        deviationDataSet.addNonPartwiseControl(1, 1.0, "tempo", d /= (double)this.ticks2tempo.size());
        for (Map.Entry entry : this.ticks2tempo.entrySet()) {
            deviationDataSet.addNonPartwiseControl((Integer)entry.getKey() / (TICKS_PER_BEAT * 4) + 1, (double)((Integer)entry.getKey() % (TICKS_PER_BEAT * 4)) / (double)TICKS_PER_BEAT + 1.0, "tempo-deviation", (double)((Integer)entry.getValue()).intValue() / d);
        }
        for (DeviatedNote deviatedNote : this.deviatedNotes) {
            deviatedNote.write(deviationDataSet);
        }
        deviationDataSet.toWrapper();
        return deviationInstanceWrapper;
    }

    public class DeviatedNote
    extends MutableNote {
        private MusicXMLWrapper.Note note;
        private double attack;
        private double release;
        private double dynamics;
        private double endDynamics;
        private boolean isMissNote;
        private String partid;
        private Track track;
        private MidiEvent noteOn;
        private MidiEvent noteOff;

        private DeviatedNote(MusicXMLWrapper.Note note, boolean bl, Track track) throws InvalidMidiDataException {
            this(note, 0.0, 0.0, 1.0, 1.0, bl, track);
        }

        private DeviatedNote(MusicXMLWrapper.Note note, double d, double d2, double d3, double d4, boolean bl, Track track) throws InvalidMidiDataException {
            this(note, note.onset(TICKS_PER_BEAT), note.offset(TICKS_PER_BEAT), note.notenum(), d, d2, d3, d4, bl, null, track);
        }

        private DeviatedNote(MusicXMLWrapper.Note note, int n, int n2, int n3, double d, double d2, double d3, double d4, boolean bl, String string, Track track) throws InvalidMidiDataException {
            super(n, n2, n3, CompiledDeviation.this.BASE_DYNAMICS, CompiledDeviation.this.BASE_DYNAMICS, TICKS_PER_BEAT);
            this.note = note;
            this.attack = d;
            this.release = d2;
            this.dynamics = d3;
            this.endDynamics = d4;
            this.partid = string;
            this.track = track;
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144, this.notenum(), this.velocity());
            this.noteOn = new MidiEvent(shortMessage, this.onset());
            ShortMessage shortMessage2 = new ShortMessage();
            shortMessage2.setMessage(128, this.notenum(), this.offVelocity());
            this.noteOff = new MidiEvent(shortMessage2, this.offset());
            track.add(this.noteOn);
            track.add(this.noteOff);
            this.setMissNote(bl);
        }

        public int onset() {
            return super.onset() + (int)((double)TICKS_PER_BEAT * this.attack);
        }

        public int onsetOriginal() {
            return super.onset();
        }

        public int onsetInMSec() {
            return this.tickInMSec(new OnsetHandler());
        }

        public int onsetOriginalInMSec() {
            return this.tickInMSec(new OnsetOriginalHandler());
        }

        public int offset() {
            return super.offset() + (int)((double)TICKS_PER_BEAT * this.release);
        }

        public int offsetOriginal() {
            return super.offset();
        }

        public int offsetInMSec() {
            return this.tickInMSec(new OffsetHandler());
        }

        public int offsetOriginalInMSec() {
            return this.tickInMSec(new OffsetOriginalHandler());
        }

        private int tickInMSec(TickHandler tickHandler) {
            int n = 0;
            Iterator iterator = CompiledDeviation.this.ticks2msec.keySet().iterator();
            while (iterator.hasNext()) {
                int n2;
                n = n2 = ((Integer)iterator.next()).intValue();
                if (n2 <= tickHandler.tick()) continue;
                break;
            }
            return (Integer)CompiledDeviation.this.ticks2msec.get(n) + (int)((double)(tickHandler.tick() - n) / (double)TICKS_PER_BEAT / (double)((Integer)CompiledDeviation.this.ticks2tempo.get(n)).intValue() * 60.0 * 1000.0);
        }

        public int velocity() {
            if (this.isMissNote) {
                return 0;
            }
            return Math.min((int)((double)super.velocity() * this.dynamics), 127);
        }

        public int offVelocity() {
            return Math.min((int)((double)super.offVelocity() * this.endDynamics), 127);
        }

        public MusicXMLWrapper.Note getNote() {
            return this.note;
        }

        public boolean isExtraNote() {
            return this.note == null;
        }

        public double getAttack() {
            return this.attack;
        }

        public double getRelease() {
            return this.release;
        }

        public double getDynamics() {
            return this.dynamics;
        }

        public double getEndDynamics() {
            return this.endDynamics;
        }

        public boolean getIsMissNote() {
            return this.isMissNote;
        }

        public void setMissNote(boolean bl) throws InvalidMidiDataException {
            this.isMissNote = bl;
            this.updateMidiEvent();
        }

        public boolean changeDeviation(double d, double d2) throws InvalidMidiDataException {
            return this.changeDeviation(d, d2, this.dynamics, this.endDynamics);
        }

        public boolean changeDeviation(double d, double d2, double d3, double d4) throws InvalidMidiDataException {
            this.attack += d;
            this.release += d2;
            if (this.onset() >= this.offset() || d3 < 0.0 || d4 < 0.0) {
                this.attack -= d;
                this.release -= d2;
                return false;
            }
            this.dynamics = d3;
            this.endDynamics = d4;
            this.updateMidiEvent();
            return true;
        }

        public boolean changeAttackInMsec(int n) throws InvalidMidiDataException {
            int n2 = (Integer)CompiledDeviation.this.ticks2msec.firstKey();
            for (Map.Entry entry : CompiledDeviation.this.ticks2msec.entrySet()) {
                if ((Integer)entry.getValue() > n) break;
                n2 = (Integer)entry.getKey();
            }
            double d = (double)((Integer)CompiledDeviation.this.ticks2tempo.get(n2)).intValue() / 60.0;
            double d2 = (double)(n - (Integer)CompiledDeviation.this.ticks2msec.get(n2)) / 1000.0;
            int n3 = (int)(d * d2 * (double)TICKS_PER_BEAT);
            int n4 = n2 + n3;
            return this.changeDeviation((double)(n4 - this.onset()) / (double)TICKS_PER_BEAT, 0.0);
        }

        public boolean changeReleaseInMsec(int n) throws InvalidMidiDataException {
            int n2 = (Integer)CompiledDeviation.this.ticks2msec.firstKey();
            for (Map.Entry entry : CompiledDeviation.this.ticks2msec.entrySet()) {
                if ((Integer)entry.getValue() > n) break;
                n2 = (Integer)entry.getKey();
            }
            double d = (double)((Integer)CompiledDeviation.this.ticks2tempo.get(n2)).intValue() / 60.0;
            double d2 = (double)(n - (Integer)CompiledDeviation.this.ticks2msec.get(n2)) / 1000.0;
            int n3 = (int)(d * d2 * (double)TICKS_PER_BEAT);
            int n4 = n2 + n3;
            return this.changeDeviation(0.0, (double)(n4 - this.offset()) / (double)TICKS_PER_BEAT);
        }

        private void updateMidiEvent() throws InvalidMidiDataException {
            ShortMessage shortMessage = (ShortMessage)this.noteOn.getMessage();
            shortMessage.setMessage(shortMessage.getStatus(), shortMessage.getData1(), this.velocity());
            MidiEvent midiEvent = new MidiEvent(shortMessage, this.onset());
            ShortMessage shortMessage2 = (ShortMessage)this.noteOff.getMessage();
            shortMessage2.setMessage(shortMessage2.getStatus(), shortMessage2.getData1(), this.offVelocity());
            MidiEvent midiEvent2 = new MidiEvent(shortMessage2, this.offset());
            this.track.remove(this.noteOn);
            this.track.remove(this.noteOff);
            this.track.add(midiEvent);
            this.track.add(midiEvent2);
            this.noteOn = midiEvent;
            this.noteOff = midiEvent2;
        }

        public void write(DeviationDataSet deviationDataSet) {
            if (this.note == null) {
                if (this.isMissNote) {
                    return;
                }
                int n = this.onset() / (TICKS_PER_BEAT * 4) + 1;
                double d = (double)(this.onset() % (TICKS_PER_BEAT * 4)) / (double)TICKS_PER_BEAT + 1.0;
                double d2 = (double)(this.offset() - this.onset()) / (double)TICKS_PER_BEAT;
                deviationDataSet.addExtraNote(this.partid, n, d, this.notenum(), d2, this.dynamics, this.endDynamics);
            } else if (this.isMissNote) {
                deviationDataSet.addMissNote(this.note);
            } else if (this.attack != 0.0 || this.release != 0.0 || this.dynamics != 1.0 || this.endDynamics != 1.0) {
                deviationDataSet.addNoteDeviation(this.note, this.attack, this.release, this.dynamics, this.endDynamics);
            }
        }

        private class OffsetOriginalHandler
        extends TickHandler {
            private OffsetOriginalHandler() {
            }

            int tick() {
                return DeviatedNote.this.offsetOriginal();
            }
        }

        private class OffsetHandler
        extends TickHandler {
            private OffsetHandler() {
            }

            int tick() {
                return DeviatedNote.this.offset();
            }
        }

        private class OnsetOriginalHandler
        extends TickHandler {
            private OnsetOriginalHandler() {
            }

            int tick() {
                return DeviatedNote.this.onsetOriginal();
            }
        }

        private class OnsetHandler
        extends TickHandler {
            private OnsetHandler() {
            }

            int tick() {
                return DeviatedNote.this.onset();
            }
        }

        private abstract class TickHandler {
            private TickHandler() {
            }

            abstract int tick();
        }
    }
}

