/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.bayesband.sound;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import jp.crestmuse.cmx.sound.SequenceGeneratable;
import jp.crestmuse.cmx.sound.TickTimer;

public class SequencerManager
implements TickTimer,
Runnable {
    public static int TICKS_PER_BEAT = 480;
    private Sequencer sequencer = MidiSystem.getSequencer(false);
    private int currentMeasure = 0;
    private Track recordTrack;
    private List<SgWithTrack> generatables;
    private String outFileName;
    private Receiver receiver;
    private boolean finish = false;

    public SequencerManager() throws MidiUnavailableException, InvalidMidiDataException {
        this(MidiSystem.getReceiver());
    }

    public SequencerManager(Receiver receiver) throws MidiUnavailableException, InvalidMidiDataException {
        this.sequencer.getTransmitter().setReceiver(receiver);
        this.receiver = receiver;
        this.sequencer.open();
        Sequence sequence = new Sequence(0.0f, TICKS_PER_BEAT);
        this.sequencer.setSequence(sequence);
        this.generatables = new LinkedList<SgWithTrack>();
    }

    public long getTickPosition() {
        return this.sequencer.getTickPosition();
    }

    @Override
    public void run() {
        for (SgWithTrack object : this.generatables) {
            object.sg.sendInitializingMessages(this.receiver);
            object.sg.changeMeasure(object.track, 0L);
            this.currentMeasure = 1;
            object.terminal.setTick(TICKS_PER_BEAT * 4);
        }
        this.sequencer.start();
        boolean bl = true;
        while (bl && !this.finish) {
            if (this.sequencer.getTickPosition() >= (long)(this.currentMeasure * TICKS_PER_BEAT * 4 - TICKS_PER_BEAT / 6)) {
                ++this.currentMeasure;
                bl = false;
                for (SgWithTrack sgWithTrack : this.generatables) {
                    bl |= sgWithTrack.sg.changeMeasure(sgWithTrack.track, (long)((this.currentMeasure - 1) * TICKS_PER_BEAT * 4));
                    if (sgWithTrack.terminal.getTick() >= (long)(TICKS_PER_BEAT * 4 * this.currentMeasure)) continue;
                    sgWithTrack.terminal.setTick(TICKS_PER_BEAT * 4 * this.currentMeasure);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        this.sequencer.stop();
        if (this.outFileName != null) {
            try {
                MidiSystem.write(this.sequencer.getSequence(), 1, new File(this.outFileName));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.sequencer.close();
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    public void addGeneratable(SequenceGeneratable sequenceGeneratable) {
        this.generatables.add(new SgWithTrack(sequenceGeneratable, this.sequencer.getSequence().createTrack()));
        try {
            this.sequencer.setSequence(this.sequencer.getSequence());
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public void setRecording(String string) {
        this.outFileName = string;
    }

    public Track getRecordTrack() {
        if (this.recordTrack == null) {
            this.recordTrack = this.sequencer.getSequence().createTrack();
            try {
                this.sequencer.setSequence(this.sequencer.getSequence());
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
            }
        }
        return this.recordTrack;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stop() {
        this.finish = true;
    }

    private class SgWithTrack {
        SequenceGeneratable sg;
        Track track;
        MidiEvent terminal;

        SgWithTrack(SequenceGeneratable sequenceGeneratable, Track track) {
            this.sg = sequenceGeneratable;
            this.track = track;
            this.terminal = track.get(0);
        }
    }
}

