/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.bayesband.inference;

import java.util.LinkedList;
import jp.crestmuse.cmx.bayesband.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.bayesband.inference.BayesianMapping;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;

public class BayesianCalculator
implements Calculator {
    private BayesNetWrapper bayesNet;
    private LinkedList<BayesianMapping> readMappings;
    private LinkedList<BayesianMapping> writeMappings;

    public BayesianCalculator(BayesNetWrapper bayesNetWrapper) {
        this.bayesNet = bayesNetWrapper;
        this.readMappings = new LinkedList();
        this.writeMappings = new LinkedList();
    }

    public void update(MusicRepresentation musicRepresentation, MusicRepresentation.MusicElement musicElement, int n) {
        MusicRepresentation.MusicElement musicElement2;
        int n2 = n / musicRepresentation.getDivision() + 1;
        if (n2 == musicRepresentation.getMeasureNum()) {
            return;
        }
        for (BayesianMapping bayesianMapping : this.readMappings) {
            musicElement2 = musicRepresentation.getMusicElement(bayesianMapping.layer, bayesianMapping.musicRepIndex(musicRepresentation, n));
            this.bayesNet.setEvidence(bayesianMapping.bayesnetIndex, musicElement2.getLabel(musicElement2.getHighestProbIndex()));
        }
        this.bayesNet.update();
        for (BayesianMapping bayesianMapping : this.writeMappings) {
            musicElement2 = musicRepresentation.getMusicElement(bayesianMapping.layer, bayesianMapping.musicRepIndex(musicRepresentation, n));
            double[] dArray = this.bayesNet.getMargin(bayesianMapping.bayesnetIndex);
            for (int i = 0; i < dArray.length; ++i) {
                musicElement2.setProb(i, dArray[i]);
            }
            if (!bayesianMapping.update) continue;
            musicRepresentation.update(bayesianMapping.layer, bayesianMapping.musicRepIndex(musicRepresentation, n));
        }
    }

    public void addReadMapping(BayesianMapping bayesianMapping) {
        this.readMappings.add(bayesianMapping);
    }

    public void addWriteMapping(BayesianMapping bayesianMapping) {
        this.writeMappings.add(bayesianMapping);
    }
}

