/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.bayesband;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.SPSpreadModule;
import jp.crestmuse.cmx.bayesband.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.bayesband.inference.AccompanimentGenerator;
import jp.crestmuse.cmx.bayesband.inference.BayesianCalculator;
import jp.crestmuse.cmx.bayesband.inference.BayesianMapping;
import jp.crestmuse.cmx.bayesband.inference.ChordPrintCalculator;
import jp.crestmuse.cmx.bayesband.inference.NaiveVoicingCalculator;
import jp.crestmuse.cmx.bayesband.sp.MelodyWriter;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.sound.SequenceGeneratable;
import jp.crestmuse.cmx.sound.SequencerManager;
import jp.crestmuse.cmx.sound.TickTimer;
import jp.crestmuse.cmx.sound.VirtualKeyboard;

public class BayesianBand {
    static MusicRepresentation mr;

    public static void main(String[] stringArray) {
        try {
            MidiInputModule midiInputModule;
            if (stringArray.length < 2) {
                System.err.println("Usage: ");
                System.err.println("$java -jar BayesianBand.jar <options> <bif_file> <mid_file>");
                System.err.println("Available options are: -start, -smf, -v, -vkb");
                System.exit(1);
            }
            int n = 8;
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = "C";
            String string4 = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-length")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-start")) {
                    string3 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-smf")) {
                    string4 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[i].equals("-vkb")) continue;
                bl2 = true;
            }
            mr = new MusicRepresentation(n, 8);
            mr.addMusicLayer("melody", 12);
            mr.addMusicLayer("chord", new String[]{"C", "Dm", "Em", "F", "G", "Am", "Bm(b5)"}, 8);
            mr.addMusicLayer("bass", 128, 2);
            mr.addMusicLayer("voicingHigh", 128, 8);
            mr.addMusicLayer("voicingMidHigh", 128, 8);
            mr.addMusicLayer("voicingMidLow", 128, 8);
            mr.addMusicLayer("voicingLow", 128, 8);
            BayesianCalculator bayesianCalculator = new BayesianCalculator(new BayesNetWrapper(string));
            bayesianCalculator.addReadMapping(new BayesianMapping("melody", -1, 1, 0));
            bayesianCalculator.addReadMapping(new BayesianMapping("chord", -1, 2, 1));
            bayesianCalculator.addReadMapping(new BayesianMapping("melody", 0, 0, 2));
            bayesianCalculator.addReadMapping(new BayesianMapping("chord", 0, 0, 3));
            bayesianCalculator.addWriteMapping(new BayesianMapping("melody", 1, 0, 4));
            bayesianCalculator.addWriteMapping(new BayesianMapping("chord", 1, 2, 5));
            NaiveVoicingCalculator naiveVoicingCalculator = new NaiveVoicingCalculator();
            mr.addCalculator("melody", (Calculator)bayesianCalculator);
            mr.addCalculator("chord", (Calculator)naiveVoicingCalculator);
            mr.addCalculator("melody", (Calculator)new ChordPrintCalculator());
            MusicRepresentation.MusicElement musicElement = mr.getMusicElement("chord", 0);
            musicElement.setProb(musicElement.indexOf(string3), 1.0);
            mr.update("chord", 0);
            Sequencer sequencer = null;
            if (string4 != null) {
                sequencer = MidiSystem.getSequencer(false);
                sequencer.setSequence(MidiSystem.getSequence(new File(string4)));
                midiInputModule = new MidiInputModule((MidiDevice)sequencer);
            } else {
                midiInputModule = bl2 ? new MidiInputModule((MidiDevice)new VirtualKeyboard()) : new MidiInputModule(BayesianBand.getMidiDevice(true));
            }
            SPExecutor sPExecutor = new SPExecutor();
            MelodyWriter melodyWriter = new MelodyWriter(mr, bl);
            MidiDevice midiDevice = BayesianBand.getMidiDevice(false);
            midiDevice.open();
            MidiOutputModule midiOutputModule = new MidiOutputModule(midiDevice.getReceiver());
            SequencerManager sequencerManager = new SequencerManager(midiDevice.getReceiver());
            if (string4 != null) {
                sequencer.setMasterSyncMode(sequencerManager.getSequencer().getMasterSyncMode());
            }
            AccompanimentGenerator accompanimentGenerator = new AccompanimentGenerator(mr, string2);
            sequencerManager.addGeneratable((SequenceGeneratable)accompanimentGenerator);
            midiInputModule.setTickTimer((TickTimer)sequencerManager);
            SPSpreadModule sPSpreadModule = new SPSpreadModule(MidiEventWithTicktime.class, 2);
            sPExecutor.addSPModule((ProducerConsumerCompatible)midiInputModule);
            sPExecutor.addSPModule((ProducerConsumerCompatible)sPSpreadModule);
            sPExecutor.addSPModule((ProducerConsumerCompatible)midiOutputModule);
            sPExecutor.addSPModule((ProducerConsumerCompatible)melodyWriter);
            sPExecutor.connect((ProducerConsumerCompatible)midiInputModule, 0, (ProducerConsumerCompatible)sPSpreadModule, 0);
            sPExecutor.connect((ProducerConsumerCompatible)sPSpreadModule, 0, (ProducerConsumerCompatible)midiOutputModule, 0);
            sPExecutor.connect((ProducerConsumerCompatible)sPSpreadModule, 1, (ProducerConsumerCompatible)melodyWriter, 0);
            sPExecutor.start();
            sequencerManager.start();
            if (string4 != null) {
                sequencer.start();
            }
            System.err.println("press button to exit...");
            System.in.read();
            sequencerManager.stop();
            sPExecutor.stop();
            midiDevice.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public static MidiDevice getMidiDevice(boolean bl) {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        MidiDevice midiDevice = null;
        for (int i = 0; i < infoArray.length; ++i) {
            try {
                midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
                if (bl && midiDevice.getMaxTransmitters() == 0 || !bl && midiDevice.getMaxReceivers() == 0) continue;
                System.err.println("*** " + i + " ***");
                System.err.println("  Description:" + infoArray[i].getDescription());
                System.err.println("  Name:" + infoArray[i].getName());
                System.err.println("  Vendor:" + infoArray[i].getVendor());
                System.err.println();
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in), 1);
            if (bl) {
                System.err.print("Using Input Device Number: ");
            } else {
                System.err.print("Using Output Device Number: ");
            }
            String string = bufferedReader.readLine();
            midiDevice = MidiSystem.getMidiDevice(infoArray[Integer.parseInt(string)]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return midiDevice;
    }
}

