/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.inference.MusicRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MelodyWriter
extends SPModule {
    private MusicRepresentation mr;
    private boolean writeLog;

    public MelodyWriter(MusicRepresentation musicRepresentation) {
        this(musicRepresentation, false);
    }

    public MelodyWriter(MusicRepresentation musicRepresentation, boolean bl) {
        this.mr = musicRepresentation;
        this.writeLog = bl;
    }

    @Override
    public void execute(SPElement[] sPElementArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) throws InterruptedException {
        MidiEventWithTicktime midiEventWithTicktime = (MidiEventWithTicktime)sPElementArray[0];
        byte[] byArray = midiEventWithTicktime.getMessage().getMessage();
        if ((byArray[0] & 0xF0) == 144 && byArray[2] > 0) {
            int n = this.mr.getIndex(midiEventWithTicktime.music_position);
            MusicRepresentation.MusicElement musicElement = this.mr.getMusicElement("melody", n);
            musicElement.setEvidence(byArray[1] % 12);
            this.mr.update("melody", n);
            if (this.writeLog) {
                int n2;
                int n3 = n + 1;
                if (n3 < this.mr.getDivision() * this.mr.getMeasureNum()) {
                    System.out.println(midiEventWithTicktime.music_position + ", " + byArray[1] + ", " + byArray[2]);
                    MusicRepresentation.MusicElement musicElement2 = this.mr.getMusicElement("melody", n3);
                    if (musicElement2.set()) {
                        for (int i = 0; i < 11; ++i) {
                            System.out.print(musicElement2.getLabel(i) + ":" + musicElement2.getProb(i) + ", ");
                        }
                        System.out.print(musicElement2.getLabel(11) + ":" + musicElement2.getProb(11));
                        System.out.println();
                    }
                }
                if ((n2 = (n / this.mr.getDivision() + 1) * this.mr.getDivision()) < this.mr.getDivision() * this.mr.getMeasureNum()) {
                    MusicRepresentation.MusicElement musicElement3 = this.mr.getMusicElement("chord", n2);
                    if (musicElement3.set()) {
                        for (int i = 0; i < 6; ++i) {
                            System.out.print(musicElement3.getLabel(i) + ":" + musicElement3.getProb(i) + ", ");
                        }
                        System.out.print(musicElement3.getLabel(6) + ":" + musicElement3.getProb(6));
                    }
                    System.out.println();
                }
            }
        }
    }

    @Override
    public Class<SPElement>[] getInputClasses() {
        return new Class[]{MidiEventWithTicktime.class};
    }

    @Override
    public Class<SPElement>[] getOutputClasses() {
        return new Class[0];
    }
}

