/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GUI
extends JPanel
implements Runnable,
KeyListener {
    private Random random;
    private LinkedList<Star> stars;
    private Color[] rainbow = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, new Color(35, 71, 148), new Color(167, 87, 168)};
    private Color backgroundTarget;
    private int colorLimit;
    private double elapsed;
    private static GUI instance;

    public static GUI getInstance() {
        if (instance == null) {
            instance = new GUI();
        }
        return instance;
    }

    private GUI() {
        this.setSize(1024, 512);
        this.setBackground(Color.BLACK);
        this.backgroundTarget = Color.BLACK;
        this.colorLimit = 5;
        this.random = new Random();
        this.stars = new LinkedList();
        Thread thread = new Thread(this);
        thread.start();
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(this);
        jFrame.setSize(1024, 512);
        jFrame.addKeyListener(this);
        jFrame.setVisible(true);
    }

    public void run() {
        long l = System.currentTimeMillis();
        while (true) {
            long l2 = System.currentTimeMillis();
            this.elapsed = (double)(l2 - l) / 1000.0;
            l = l2;
            try {
                this.update();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
            this.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private void update() throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                Color color = GUI.this.getBackground();
                int n = color.getRed() + Math.max(Math.min(GUI.this.backgroundTarget.getRed() - color.getRed(), GUI.this.colorLimit), -GUI.this.colorLimit);
                int n2 = color.getGreen() + Math.max(Math.min(GUI.this.backgroundTarget.getGreen() - color.getGreen(), GUI.this.colorLimit), -GUI.this.colorLimit);
                int n3 = color.getBlue() + Math.max(Math.min(GUI.this.backgroundTarget.getBlue() - color.getBlue(), GUI.this.colorLimit), -GUI.this.colorLimit);
                GUI.this.setBackground(new Color(n, n2, n3));
                int n4 = 0;
                while (n4 < GUI.this.stars.size()) {
                    if (((Star)GUI.this.stars.get(n4)).update(GUI.this.elapsed)) {
                        ++n4;
                        continue;
                    }
                    GUI.this.stars.remove(n4);
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (Star star : this.stars) {
            star.paint(graphics);
        }
        graphics.setColor(this.getBackground());
        graphics.fillOval(this.getWidth() / 2 - 50, this.getHeight() / 2 - 50, 100, 100);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        for (int i = 0; i < 100; ++i) {
            this.stars.add(new Star(this.rainbow[this.random.nextInt(7)]));
        }
        this.backgroundTarget = this.rainbow[this.random.nextInt(7)].darker().darker();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(final double[] dArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < 7; ++i) {
                    int n = 0;
                    while ((double)n < dArray[i] * 100.0) {
                        GUI.this.stars.add(new Star(GUI.this.rainbow[i]));
                        ++n;
                    }
                }
            }
        });
    }

    public void changeMeasure(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUI.this.backgroundTarget = GUI.this.rainbow[n].darker();
            }
        });
    }

    public static void main(String[] stringArray) {
        new GUI();
    }

    private class Star {
        double x;
        double y;
        double vx;
        double vy;
        double ax;
        double ay;
        double r;
        double startvx;
        double startvy;
        Color color;
        int avelage = 750;
        int variance = 100;
        int centerx = GUI.this.getWidth() / 2;
        int centery = GUI.this.getHeight() / 2;

        Star(Color color) {
            this.x = this.centerx;
            this.y = this.centery;
            this.vx = GUI.this.random.nextDouble();
            this.vy = GUI.this.random.nextDouble();
            double d = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
            this.vx = this.vx / d * (double)(this.avelage + GUI.this.random.nextInt(this.variance)) * (double)(GUI.this.random.nextBoolean() ? 1 : -1);
            this.vy = this.vy / d * (double)(this.avelage + GUI.this.random.nextInt(this.variance)) * (double)(GUI.this.random.nextBoolean() ? 1 : -1);
            this.startvx = this.vx;
            this.startvy = this.vy;
            this.ax = -this.vx;
            this.ay = -this.vy;
            this.r = 10.0;
            this.color = color;
        }

        boolean update(double d) {
            this.vx += this.ax * d;
            this.vy += this.ay * d;
            this.x += this.vx * d;
            this.y += this.vy * d;
            this.r = (((double)this.centerx - this.x) * ((double)this.centerx - this.x) + ((double)this.centery - this.y) * ((double)this.centery - this.y)) / 700.0;
            return !(this.startvx * (this.x - (double)this.centerx) < 0.0) && !(this.startvy * (this.y - (double)this.centery) < 0.0);
        }

        void paint(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.drawLine((int)this.x, (int)this.y, this.centerx, this.centery);
            graphics.fillOval((int)(this.x - this.r / 2.0), (int)(this.y - this.r / 2.0), (int)this.r, (int)this.r);
        }
    }
}

