/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import jp.crestmuse.cmx.inference.MusicRepresentation;

public class BayesianMapping {
    final String layer;
    final int musRepPosition;
    final int option;
    final int bayesnetIndex;
    final boolean update;
    public static final int NORMAL = 0;
    public static final int SET_ONLY = 1;
    public static final int BY_TIED_LENGTH = 2;
    public static final int MEASURE_HEAD = 4;

    public BayesianMapping(String string, int n, int n2, int n3, boolean bl) {
        this.layer = string;
        this.musRepPosition = n;
        this.option = n2;
        this.bayesnetIndex = n3;
        this.update = bl;
    }

    public BayesianMapping(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, false);
    }

    protected int musicRepIndex(MusicRepresentation musicRepresentation, int n) {
        int n2;
        if (this.musRepPosition == 0) {
            return n;
        }
        int n3 = 0;
        if ((this.option & 2) == 2) {
            n2 = musicRepresentation.getTiedLength(this.layer);
        } else if ((this.option & 4) == 4) {
            n2 = musicRepresentation.getDivision();
            n = n / musicRepresentation.getDivision() * musicRepresentation.getDivision();
            if (this.musRepPosition < 0) {
                n += musicRepresentation.getDivision();
            }
        } else {
            n2 = 1;
        }
        if ((this.option & 1) == 1) {
            int n4 = this.musRepPosition > 0 ? 1 : -1;
            n += n4;
            int n5 = 0;
            while (n5 < n4 * this.musRepPosition && n >= 0) {
                MusicRepresentation.MusicElement musicElement = musicRepresentation.getMusicElement(this.layer, n);
                if (musicElement.set()) {
                    ++n5;
                }
                n += n4;
            }
        } else {
            n3 = n + this.musRepPosition * n2;
        }
        return n3 >= 0 ? n3 : 0;
    }
}

