/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.io.IOException;
import java.io.OutputStream;
import jp.crestmuse.cmx.amusaj.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import org.xml.sax.SAXException;

public class AccompanimentCalculator
implements Calculator {
    private BayesNetWrapper bayesNet;

    public AccompanimentCalculator(BayesNetWrapper bayesNetWrapper) {
        this.bayesNet = bayesNetWrapper;
    }

    public void update(MusicRepresentation musicRepresentation, MusicRepresentation.MusicElement musicElement, int n) {
        int n2;
        MusicRepresentation.MusicElement musicElement2;
        int n3 = n / musicRepresentation.getDivision() + 1;
        if (n3 == musicRepresentation.getMeasureNum()) {
            return;
        }
        int n4 = (n3 - 1) * musicRepresentation.getDivision() - 1;
        int n5 = (n3 - 2) * musicRepresentation.getDivision();
        String string = "/";
        for (int i = n - 1; i > n5 && i >= 0; --i) {
            musicElement2 = musicRepresentation.getMusicElement("melody", i);
            if (!musicElement2.set()) continue;
            string = musicElement2.getHighestProbIndex() % 12 + "";
            break;
        }
        String string2 = "/";
        try {
            musicElement2 = musicRepresentation.getMusicElement("chord", n5);
            string2 = musicElement2.getLabel(musicElement2.getHighestProbIndex());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        musicElement2 = musicRepresentation.getMusicElement("chord", n4 + 1);
        String string3 = musicElement2.getLabel(musicElement2.getHighestProbIndex());
        String string4 = musicElement.getHighestProbIndex() % 12 + "";
        this.bayesNet.setEvidence(0, string);
        this.bayesNet.setEvidence(1, string2);
        this.bayesNet.setEvidence(2, string4);
        this.bayesNet.setEvidence(3, string3);
        this.bayesNet.update();
        MusicRepresentation.MusicElement musicElement3 = musicRepresentation.getMusicElement("melody", n + 1);
        for (n2 = 0; n2 < this.bayesNet.getMargin(4).length; ++n2) {
            musicElement3.setProb(n2, this.bayesNet.getMargin(4)[n2]);
        }
        n2 = n3 * musicRepresentation.getDivision();
        MusicRepresentation.MusicElement musicElement4 = musicRepresentation.getMusicElement("chord", n2);
        double[] dArray = this.bayesNet.getMargin(5);
        this.printChordLabels(musicElement4, dArray.length);
        System.err.print("|");
        for (int i = 0; i < dArray.length; ++i) {
            musicElement4.setProb(i, dArray[i]);
            for (int j = 0; j < 10; ++j) {
                if (dArray[i] > (double)j / 10.0) {
                    System.err.print("*");
                    continue;
                }
                System.err.print(" ");
            }
            System.err.print("|");
        }
        System.err.println();
        musicRepresentation.update("chord", n2);
    }

    public void writeBif(OutputStream outputStream) throws IOException, SAXException {
        this.bayesNet.write(outputStream);
    }

    private void printChordLabels(MusicRepresentation.MusicElement musicElement, int n) {
        System.err.print("|");
        for (int i = 0; i < n; ++i) {
            System.err.printf("%-10s|", musicElement.getLabel(i));
        }
        System.err.println();
    }
}

