/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.LinkedList;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPIllegalConnectionException;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPGroup
extends SPModule {
    private Class<SPElement>[] inputClasses;
    private Class<SPElement>[] outputClasses;
    private LinkedList<SPGroupModule> modules = new LinkedList();
    TimeSeriesCompatible<SPElement>[] headDest;
    QueueReader<SPElement>[] tailSrc;

    @Override
    public void execute(SPElement[] sPElementArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) throws InterruptedException {
        for (int i = 0; i < sPElementArray.length; ++i) {
            this.headDest[i].add(sPElementArray[i]);
        }
        for (SPGroupModule sPGroupModule : this.modules) {
            sPGroupModule.run();
        }
        if (this.tailSrc == null) {
            this.tailSrc = new QueueReader[this.outputClasses.length];
            for (int i = 0; i < this.outputClasses.length; ++i) {
                this.tailSrc[i] = this.modules.getLast().dest[i].getQueueReader();
            }
        }
        for (int i = 0; i < this.outputClasses.length; ++i) {
            timeSeriesCompatibleArray[i].add(this.tailSrc[i].take());
        }
    }

    @Override
    public Class<SPElement>[] getInputClasses() {
        return this.inputClasses;
    }

    @Override
    public Class<SPElement>[] getOutputClasses() {
        return this.outputClasses;
    }

    public void addModule(ProducerConsumerCompatible producerConsumerCompatible) {
        SPGroupModule sPGroupModule = new SPGroupModule(producerConsumerCompatible);
        if (this.modules.size() == 0) {
            this.inputClasses = producerConsumerCompatible.getInputClasses();
            this.headDest = new TimeSeriesCompatible[this.inputClasses.length];
            for (int i = 0; i < this.inputClasses.length; ++i) {
                this.headDest[i] = new MutableTimeSeries<SPElement>();
                sPGroupModule.src[i] = this.headDest[i].getQueueReader();
            }
        } else {
            SPGroupModule sPGroupModule2 = this.modules.getLast();
            if (sPGroupModule2.outputChannelNum != sPGroupModule.inputChannelNum) {
                throw new SPIllegalConnectionException("different channel length " + sPGroupModule2.module.getClass().getName() + " and " + sPGroupModule.module.getClass().getName());
            }
            for (int i = 0; i < sPGroupModule2.outputChannelNum; ++i) {
                if (sPGroupModule2.module.getOutputClasses()[i] != producerConsumerCompatible.getInputClasses()[i]) {
                    throw new SPIllegalConnectionException("can't connect " + sPGroupModule2.module.getOutputClasses()[i].getName() + " and " + producerConsumerCompatible.getInputClasses()[i].getName());
                }
                sPGroupModule.src[i] = sPGroupModule2.dest[i].getQueueReader();
            }
        }
        this.modules.add(sPGroupModule);
        this.outputClasses = producerConsumerCompatible.getOutputClasses();
    }

    @Override
    public void stop(QueueReader<SPElement>[] queueReaderArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) {
        for (SPGroupModule sPGroupModule : this.modules) {
            sPGroupModule.stop();
        }
    }

    private class SPGroupModule {
        ProducerConsumerCompatible module;
        QueueReader<SPElement>[] src;
        TimeSeriesCompatible<SPElement>[] dest;
        SPElement[] inputElements;
        int inputChannelNum;
        int outputChannelNum;

        SPGroupModule(ProducerConsumerCompatible producerConsumerCompatible) {
            this.inputChannelNum = producerConsumerCompatible.getInputClasses().length;
            this.outputChannelNum = producerConsumerCompatible.getOutputClasses().length;
            this.module = producerConsumerCompatible;
            this.src = new QueueReader[this.inputChannelNum];
            this.dest = new TimeSeriesCompatible[this.outputChannelNum];
            this.inputElements = new SPElement[this.inputChannelNum];
            for (int i = 0; i < this.outputChannelNum; ++i) {
                this.dest[i] = new MutableTimeSeries<SPElement>();
            }
        }

        void run() {
            try {
                for (int i = 0; i < this.inputChannelNum; ++i) {
                    this.inputElements[i] = this.src[i].take();
                }
                if (this.inputChannelNum > 0 && this.inputElements[0] instanceof SPTerminator) {
                    for (TimeSeriesCompatible<SPElement> timeSeriesCompatible : this.dest) {
                        timeSeriesCompatible.add(new SPTerminator());
                    }
                    return;
                }
                this.module.execute(this.inputElements, this.dest);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        void stop() {
            this.module.stop(this.src, this.dest);
        }
    }
}

