/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.XRFFLoader;
import weka.core.xml.XMLInstances;

public class XRFFSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -7226404765213522043L;
    protected SingleIndex m_ClassIndex = new SingleIndex();
    protected XMLInstances m_XMLInstances;
    protected boolean m_CompressOutput = false;

    public XRFFSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in the XML version of the ARFF format. The data can be compressed with gzip, in order to save space.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe class index (first and last are valid as well).\n\t(default: last)", "C", 1, "-C <class index>"));
        vector.addElement(new Option("\tCompresses the data (uses '" + XRFFLoader.FILE_EXTENSION_COMPRESSED + "' as extension instead of '" + XRFFLoader.FILE_EXTENSION + "')\n" + "\t(default: off)", "compress", 0, "-compress"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getClassIndex().length() != 0) {
            vector.add("-C");
            vector.add(this.getClassIndex());
        }
        if (this.getCompressOutput()) {
            vector.add("-compress");
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setClassIndex(string);
        } else {
            this.setClassIndex("last");
        }
        this.setCompressOutput(Utils.getFlag("compress", stringArray));
        super.setOptions(stringArray);
    }

    public String getFileDescription() {
        return "XRFF data files";
    }

    public String[] getFileExtensions() {
        return new String[]{XRFFLoader.FILE_EXTENSION, XRFFLoader.FILE_EXTENSION_COMPRESSED};
    }

    public void setFile(File file) throws IOException {
        if (file.getAbsolutePath().endsWith(XRFFLoader.FILE_EXTENSION_COMPRESSED)) {
            this.setCompressOutput(true);
        }
        super.setFile(file);
    }

    public void resetOptions() {
        super.resetOptions();
        if (this.getCompressOutput()) {
            this.setFileExtension(XRFFLoader.FILE_EXTENSION_COMPRESSED);
        } else {
            this.setFileExtension(XRFFLoader.FILE_EXTENSION);
        }
        try {
            this.m_XMLInstances = new XMLInstances();
        }
        catch (Exception exception) {
            this.m_XMLInstances = null;
        }
    }

    public String classIndexTipText() {
        return "Sets the class index (\"first\" and \"last\" are valid values)";
    }

    public String getClassIndex() {
        return this.m_ClassIndex.getSingleIndex();
    }

    public void setClassIndex(String string) {
        this.m_ClassIndex.setSingleIndex(string);
    }

    public String compressOutputTipText() {
        return "Optional compression of the output data";
    }

    public boolean getCompressOutput() {
        return this.m_CompressOutput;
    }

    public void setCompressOutput(boolean bl) {
        this.m_CompressOutput = bl;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void setInstances(Instances instances) {
        if (this.m_ClassIndex.getSingleIndex().length() != 0) {
            this.m_ClassIndex.setUpper(instances.numAttributes() - 1);
            instances.setClassIndex(this.m_ClassIndex.getIndex());
        }
        super.setInstances(instances);
    }

    public void setDestination(OutputStream outputStream) throws IOException {
        if (this.getCompressOutput()) {
            super.setDestination(new GZIPOutputStream(outputStream));
        } else {
            super.setDestination(outputStream);
        }
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        this.m_XMLInstances.setInstances(this.getInstances());
        if (this.retrieveFile() == null && this.getWriter() == null) {
            System.out.println(this.m_XMLInstances.toString());
            this.setWriteMode(1);
        } else {
            PrintWriter printWriter = new PrintWriter(this.getWriter());
            printWriter.println(this.m_XMLInstances.toString());
            printWriter.flush();
            printWriter.close();
            this.setWriteMode(1);
            printWriter = null;
            this.resetWriter();
            this.setWriteMode(2);
        }
    }

    public static void main(String[] stringArray) {
        XRFFSaver.runFileSaver(new XRFFSaver(), stringArray);
    }
}

