/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.LinkedList;
import java.util.List;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.sound.SequencerManager;

public class MusicRepresentation {
    private int measureNum;
    private int division;
    private MusicElement[] melodyElements;
    private MusicElement[] chordElements;
    private MusicElement[] bassElements;
    private List<Calculator> melodyCalculators;
    private List<Calculator> chordCalculators;
    private List<Calculator> bassCalculators;
    private int tiedMelodyLength;
    private int tiedChordLength;
    private int tiedBassLength;

    public MusicRepresentation(int n, int n2) {
        this.measureNum = n;
        this.division = n2;
        this.melodyElements = new MusicElement[n * n2];
        this.chordElements = new MusicElement[n * n2];
        this.bassElements = new MusicElement[n * n2];
        this.melodyCalculators = new LinkedList<Calculator>();
        this.chordCalculators = new LinkedList<Calculator>();
        this.bassCalculators = new LinkedList<Calculator>();
        this.tiedMelodyLength = 1;
        this.tiedChordLength = 1;
        this.tiedBassLength = 1;
    }

    public int getMeasureNum() {
        return this.measureNum;
    }

    public int getDivision() {
        return this.division;
    }

    public MusicElement getMelodyElement(int n) {
        return this.melodyElements[n];
    }

    public MusicElement addMelodyElement(int n) {
        this.melodyElements[n] = new MusicElement(Type.Melody, n);
        return this.melodyElements[n];
    }

    public MusicElement getChordElement(int n) {
        return this.chordElements[n];
    }

    public MusicElement addChordElement(int n) {
        this.chordElements[n] = new MusicElement(Type.Chord, n);
        return this.chordElements[n];
    }

    public MusicElement getBassElement(int n) {
        return this.bassElements[n];
    }

    public MusicElement addBassElement(int n) {
        this.bassElements[n] = new MusicElement(Type.Bass, n);
        return this.bassElements[n];
    }

    public int getTiedMelodyLength() {
        return this.tiedMelodyLength;
    }

    public void setTiedMelodyLength(int n) {
        this.tiedMelodyLength = n;
    }

    public int getTiedChordLength() {
        return this.tiedChordLength;
    }

    public void setTiedChordLength(int n) {
        this.tiedChordLength = n;
    }

    public int getTiedBassLength() {
        return this.tiedBassLength;
    }

    public void setTiedBassLength(int n) {
        this.tiedBassLength = n;
    }

    public int getIndex(long l) {
        int n = SequencerManager.TICKS_PER_BEAT * 4;
        int n2 = (int)(l / (long)n);
        int n3 = (int)(l % (long)n) / (n / this.division);
        return n2 * this.division + n3;
    }

    public void addCalculator(Calculator calculator) {
        for (Type type : calculator.drivenBy()) {
            if (type == Type.Melody) {
                this.melodyCalculators.add(calculator);
                continue;
            }
            if (type == Type.Chord) {
                this.chordCalculators.add(calculator);
                continue;
            }
            this.bassCalculators.add(calculator);
        }
    }

    public class MusicElement {
        private double[] prob;
        private boolean isEvidence;
        private int evidence;
        private boolean isNote;
        private Type type;
        private int index;
        private String[] chordLabel = new String[]{"C", "Dm", "Em", "F", "G", "Am", "Bm(b5)"};

        public MusicElement(Type type, int n) {
            this.type = type;
            this.isNote = type != Type.Chord;
            this.index = n;
            this.prob = new double[128];
        }

        public double getProb(int n) {
            if (this.isEvidence) {
                if (this.evidence == n) {
                    return 1.0;
                }
                return 0.0;
            }
            return this.prob[n];
        }

        public int getHighestProbIndex() {
            if (this.isEvidence) {
                return this.evidence;
            }
            double d = Double.MIN_VALUE;
            int n = 0;
            for (int i = 0; i < this.prob.length; ++i) {
                if (!(this.prob[i] > d)) continue;
                d = this.prob[i];
                n = i;
            }
            return n;
        }

        public void setEvidence(int n) {
            this.isEvidence = true;
            this.evidence = n;
            if (this.type == Type.Melody) {
                for (Calculator calculator : MusicRepresentation.this.melodyCalculators) {
                    calculator.update(this, this.index);
                }
            } else if (this.type == Type.Chord) {
                for (Calculator calculator : MusicRepresentation.this.chordCalculators) {
                    calculator.update(this, this.index);
                }
            } else {
                for (Calculator calculator : MusicRepresentation.this.bassCalculators) {
                    calculator.update(this, this.index);
                }
            }
        }

        public void setProb(int n, double d) {
            this.isEvidence = false;
            this.prob[n] = d;
        }

        public String getLabel(int n) {
            if (this.isNote) {
                return n + "";
            }
            return this.chordLabel[n];
        }

        public int indexOf(String string) {
            for (int i = 0; i < this.chordLabel.length; ++i) {
                if (!this.chordLabel[i].equals(string)) continue;
                return i;
            }
            return Integer.parseInt(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Melody,
        Chord,
        Bass;

    }
}

