/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.SPDummyObject;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityViewer
extends SPModule<MidiEventWithTicktime, SPDummyObject> {
    private PrintWriter pw;
    private FileOutputStream fos;

    public VelocityViewer(String string) throws FileNotFoundException {
        this.fos = new FileOutputStream(new File(string), true);
        this.pw = new PrintWriter(this.fos);
    }

    @Override
    public void execute(List<QueueReader<MidiEventWithTicktime>> list, List<TimeSeriesCompatible<SPDummyObject>> list2) throws InterruptedException {
        MidiEventWithTicktime midiEventWithTicktime = list.get(0).take();
        ShortMessage shortMessage = (ShortMessage)midiEventWithTicktime.getMessage();
        if ((shortMessage.getCommand() & 0xF0) == 144 && shortMessage.getData2() > 0) {
            System.out.println(System.currentTimeMillis() + "\t" + shortMessage.getData1() + "\t" + shortMessage.getData2());
            this.pw.println(System.currentTimeMillis() + "\t" + shortMessage.getData1() + "\t" + shortMessage.getData2());
        }
    }

    @Override
    public int getInputChannels() {
        return 1;
    }

    @Override
    public int getOutputChannels() {
        return 1;
    }

    @Override
    public void stop(List<QueueReader<MidiEventWithTicktime>> list, List<TimeSeriesCompatible<SPDummyObject>> list2) {
        this.pw.println();
        this.pw.close();
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "out.txt";
            if (stringArray.length == 1) {
                string = stringArray[0];
            }
            SPExecutor sPExecutor = new SPExecutor(null, 0);
            MidiInputModule midiInputModule = new MidiInputModule(VelocityViewer.getMidiDevice(true));
            VelocityViewer velocityViewer = new VelocityViewer(string);
            sPExecutor.addSPModule(midiInputModule);
            sPExecutor.addSPModule(velocityViewer);
            sPExecutor.connect(midiInputModule, 0, velocityViewer, 0);
            sPExecutor.start();
            System.out.println("press button to exit...");
            System.in.read();
            sPExecutor.stop();
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static MidiDevice getMidiDevice(boolean bl) {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        MidiDevice midiDevice = null;
        for (int i = 0; i < infoArray.length; ++i) {
            try {
                midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
                if (bl && midiDevice.getMaxTransmitters() == 0 || !bl && midiDevice.getMaxReceivers() == 0) continue;
                System.err.println("*** " + i + " ***");
                System.err.println("  Description:" + infoArray[i].getDescription());
                System.err.println("  Name:" + infoArray[i].getName());
                System.err.println("  Vendor:" + infoArray[i].getVendor());
                System.err.println();
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in), 1);
            if (bl) {
                System.err.print("Using Input Device Number: ");
            } else {
                System.err.print("Using Output Device Number: ");
            }
            String string = bufferedReader.readLine();
            midiDevice = MidiSystem.getMidiDevice(infoArray[Integer.parseInt(string)]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return midiDevice;
    }
}

