/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.util.ArrayList;
import java.util.List;
import jp.crestmuse.cmx.sound.MusicPlaySynchronized;
import jp.crestmuse.cmx.sound.MusicPlayer;

public class MusicPlaySynchronizer
implements Runnable {
    private MusicPlayer player;
    private List<MusicPlaySynchronized> synclist = new ArrayList<MusicPlaySynchronized>();
    private boolean playerThreadStarted = false;
    private boolean syncThreadStarted = false;
    private boolean stoppedByUser = false;
    private long sleeptime = 100L;

    public MusicPlaySynchronizer(MusicPlayer musicPlayer) {
        this.player = musicPlayer;
    }

    public void addSynchronizedComponent(MusicPlaySynchronized musicPlaySynchronized) {
        this.synclist.add(musicPlaySynchronized);
    }

    public void play() {
        this.player.play();
        if (!this.playerThreadStarted) {
            new Thread(this.player).start();
        }
        if (!this.syncThreadStarted) {
            new Thread(this).start();
        }
        this.playerThreadStarted = true;
        this.syncThreadStarted = true;
        this.stoppedByUser = false;
    }

    public void stop() {
        this.stoppedByUser = true;
        if (this.player != null) {
            this.player.stop();
        }
    }

    public boolean isStoppedByUser() {
        return this.stoppedByUser;
    }

    public boolean isNowPlaying() {
        return this.player != null && this.player.isNowPlaying();
    }

    public void setSleepTime(long l) {
        this.sleeptime = l;
    }

    public void run() {
        for (MusicPlaySynchronized musicPlaySynchronized : this.synclist) {
            musicPlaySynchronized.start(this);
        }
        while (this.isNowPlaying() || this.isStoppedByUser()) {
            if (this.isNowPlaying()) {
                long l = -1L;
                try {
                    l = this.player.getTickPosition();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                long l2 = this.player.getMicrosecondPosition();
                double d = (double)l2 / 1000000.0;
                for (MusicPlaySynchronized musicPlaySynchronized : this.synclist) {
                    musicPlaySynchronized.synchronize(d, l, this);
                }
            }
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        for (MusicPlaySynchronized musicPlaySynchronized : this.synclist) {
            musicPlaySynchronized.stop(this);
        }
        this.syncThreadStarted = false;
    }
}

