/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.gui.deveditor.PianoRollPanel;
import jp.crestmuse.cmx.gui.deveditor.PrintableDeviatedNote;

public class NoteEditFrame
extends JFrame {
    private PianoRollPanel parent;
    private PrintableDeviatedNote note;
    private JSpinner attackSpinner;
    private JSpinner releaseSpinner;
    private JSpinner dynamicsSpinner;
    private JSpinner endDynamicsSpinner;
    private JCheckBox missnote;
    private double prevAttack;
    private double prevRelease;

    public NoteEditFrame(PianoRollPanel pianoRollPanel) {
        this.parent = pianoRollPanel;
        this.setSize(new Dimension(256, 256));
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                NoteEditFrame.this.setVisible(false);
            }
        });
        this.setAttack();
        this.setRelease();
        this.setDynamics();
        this.setEndDynamics();
        this.setIsMissNote();
        JButton jButton = new JButton("reset");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NoteEditFrame.this.attackSpinner.setValue(0.0);
                NoteEditFrame.this.releaseSpinner.setValue(0.0);
                NoteEditFrame.this.dynamicsSpinner.setValue(1.0);
                NoteEditFrame.this.endDynamicsSpinner.setValue(1.0);
                NoteEditFrame.this.prevAttack = 0.0;
                NoteEditFrame.this.prevRelease = 0.0;
                NoteEditFrame.this.missnote.setSelected(false);
                NoteEditFrame.this.note.changeDeviation(0.0, 0.0, 1.0, 1.0);
                NoteEditFrame.this.note.setMissNote(false);
                NoteEditFrame.this.parent.repaint();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.add(new JLabel("attack"));
        jPanel.add(this.attackSpinner);
        jPanel.add(new JLabel("release"));
        jPanel.add(this.releaseSpinner);
        jPanel.add(new JLabel("dynamics"));
        jPanel.add(this.dynamicsSpinner);
        jPanel.add(new JLabel("endDynamincs"));
        jPanel.add(this.endDynamicsSpinner);
        jPanel.add(this.missnote);
        jPanel.add(jButton);
        this.getContentPane().add(jPanel);
    }

    private void setAttack() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        this.attackSpinner = new JSpinner(spinnerNumberModel);
        this.attackSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditFrame.this.attackSpinner.getValue();
                if (NoteEditFrame.this.note.changeDeviation(d - NoteEditFrame.this.prevAttack, 0.0, NoteEditFrame.this.note.getDeviatedNote().getDynamics(), NoteEditFrame.this.note.getDeviatedNote().getEndDynamics())) {
                    NoteEditFrame.this.prevAttack = d;
                } else {
                    NoteEditFrame.this.attackSpinner.setValue(NoteEditFrame.this.prevAttack);
                }
                NoteEditFrame.this.parent.repaint();
            }
        });
    }

    private void setRelease() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        this.releaseSpinner = new JSpinner(spinnerNumberModel);
        this.releaseSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditFrame.this.releaseSpinner.getValue();
                if (NoteEditFrame.this.note.changeDeviation(0.0, d - NoteEditFrame.this.prevRelease, NoteEditFrame.this.note.getDeviatedNote().getDynamics(), NoteEditFrame.this.note.getDeviatedNote().getEndDynamics())) {
                    NoteEditFrame.this.prevRelease = d;
                } else {
                    NoteEditFrame.this.releaseSpinner.setValue(NoteEditFrame.this.prevRelease);
                }
                NoteEditFrame.this.parent.repaint();
            }
        });
    }

    private void setDynamics() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMinimum(Double.valueOf(0.0));
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        spinnerNumberModel.setMaximum(Double.valueOf(1.0));
        this.dynamicsSpinner = new JSpinner(spinnerNumberModel);
        this.dynamicsSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditFrame.this.dynamicsSpinner.getValue();
                NoteEditFrame.this.note.changeDeviation(0.0, 0.0, d, NoteEditFrame.this.note.getDeviatedNote().getEndDynamics());
                NoteEditFrame.this.parent.repaint();
            }
        });
    }

    private void setEndDynamics() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMinimum(Double.valueOf(0.0));
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        spinnerNumberModel.setMaximum(Double.valueOf(1.0));
        this.endDynamicsSpinner = new JSpinner(spinnerNumberModel);
        this.endDynamicsSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditFrame.this.endDynamicsSpinner.getValue();
                NoteEditFrame.this.note.changeDeviation(0.0, 0.0, NoteEditFrame.this.note.getDeviatedNote().getDynamics(), d);
                NoteEditFrame.this.parent.repaint();
            }
        });
    }

    private void setIsMissNote() {
        this.missnote = new JCheckBox("missnote");
        this.missnote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NoteEditFrame.this.note.setMissNote(NoteEditFrame.this.missnote.isSelected());
                NoteEditFrame.this.parent.repaint();
            }
        });
    }

    public void setNote(PrintableDeviatedNote printableDeviatedNote) {
        this.note = printableDeviatedNote;
        this.prevAttack = printableDeviatedNote.getDeviatedNote().getAttack();
        this.prevRelease = printableDeviatedNote.getDeviatedNote().getRelease();
        this.attackSpinner.setValue(printableDeviatedNote.getDeviatedNote().getAttack());
        this.releaseSpinner.setValue(printableDeviatedNote.getDeviatedNote().getRelease());
        this.dynamicsSpinner.setValue(printableDeviatedNote.getDeviatedNote().getDynamics());
        this.endDynamicsSpinner.setValue(printableDeviatedNote.getDeviatedNote().getEndDynamics());
        this.missnote.setSelected(printableDeviatedNote.getDeviatedNote().getIsMissNote());
    }
}

