/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.handlers.NoteHandlerPartwise;
import org.xml.sax.SAXException;

public class CMXSample1
extends CMXCommand {
    private NoteHandlerPartwise handler = new HandlerSample();
    private DeviationInstanceWrapper dev;

    protected void run() throws IOException, ParserConfigurationException, TransformerException, SAXException, InvalidFileTypeException {
        this.dev = (DeviationInstanceWrapper)this.indata();
        MusicXMLWrapper musicXMLWrapper = this.dev.getTargetMusicXML();
        musicXMLWrapper.processNotePartwise(this.handler);
    }

    public static void main(String[] stringArray) {
        CMXSample1 cMXSample1 = new CMXSample1();
        try {
            cMXSample1.start(stringArray);
        }
        catch (Exception exception) {
            cMXSample1.showErrorMessage(exception);
            System.exit(1);
        }
    }

    private class HandlerSample
    implements NoteHandlerPartwise {
        private HandlerSample() {
        }

        public void beginPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
            System.out.println("New Part: " + part.id());
        }

        public void endPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
        }

        public void beginMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
        }

        public void endMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
        }

        public void processMusicData(MusicXMLWrapper.MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
            if (musicData instanceof MusicXMLWrapper.Note) {
                System.out.println("Note: ");
                MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                System.out.println("pitch-step: " + note.pitchStep());
                DeviationInstanceWrapper.NoteDeviation noteDeviation = CMXSample1.this.dev.getNoteDeviation(note);
                if (noteDeviation != null) {
                    System.out.println("dynamics: " + noteDeviation.dynamics());
                }
            }
        }
    }
}

