/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.sound.SequenceGeneratable;
import jp.crestmuse.cmx.sound.SequencerManager;

public class AccompanimentGenerator
implements SequenceGeneratable {
    public int VELOCITY = 100;
    private MusicRepresentation musicRepresentation;
    private List<ShortMessageEvent> messages;
    private List<ShortMessageEvent> channelTen;
    private List<ShortMessageEvent> programChanges;

    public AccompanimentGenerator(MusicRepresentation musicRepresentation, String string) throws InvalidMidiDataException, IOException {
        this.musicRepresentation = musicRepresentation;
        this.messages = new LinkedList<ShortMessageEvent>();
        this.channelTen = new LinkedList<ShortMessageEvent>();
        this.programChanges = new LinkedList<ShortMessageEvent>();
        Sequence sequence = MidiSystem.getSequence(new File(string));
        for (Track track : sequence.getTracks()) {
            for (int i = 0; i < track.size(); ++i) {
                ShortMessage shortMessage;
                MidiEvent midiEvent = track.get(i);
                MidiMessage midiMessage = midiEvent.getMessage();
                int n = midiMessage.getStatus() & 0xFF;
                if (n == 129 || n == 145) {
                    shortMessage = new ShortMessage();
                    shortMessage.setMessage(n, midiMessage.getMessage()[1], midiMessage.getMessage()[2]);
                    this.messages.add(new ShortMessageEvent(shortMessage, midiEvent.getTick()));
                    continue;
                }
                if (n == 137 || n == 153) {
                    shortMessage = new ShortMessage();
                    shortMessage.setMessage(n, midiMessage.getMessage()[1], midiMessage.getMessage()[2]);
                    this.channelTen.add(new ShortMessageEvent(shortMessage, midiEvent.getTick()));
                    continue;
                }
                if ((n & 0xF0) != 192) continue;
                this.programChanges.add(new ShortMessageEvent((ShortMessage)midiMessage, midiEvent.getTick()));
            }
        }
    }

    public void sendInitializingMessages(Receiver receiver) {
        for (ShortMessageEvent shortMessageEvent : this.programChanges) {
            receiver.send(shortMessageEvent.sm, shortMessageEvent.tick);
        }
    }

    public boolean changeMeasure(Track track, long l) {
        int n = (int)l / (SequencerManager.TICKS_PER_BEAT * 4) * this.musicRepresentation.getDivision();
        if (n >= this.musicRepresentation.getMeasureNum() * this.musicRepresentation.getDivision()) {
            return false;
        }
        MusicRepresentation.MusicElement musicElement = this.musicRepresentation.getChordElement(Math.max(n - this.musicRepresentation.getDivision(), 0));
        MusicRepresentation.MusicElement musicElement2 = this.musicRepresentation.getChordElement(n);
        if (musicElement2 == null) {
            musicElement2 = this.musicRepresentation.addChordElement(n);
            musicElement2.setEvidence(musicElement.getHighestProbIndex());
            this.musicRepresentation.update(MusicRepresentation.Type.Chord, musicElement2, n);
        } else if (this.musicRepresentation.getVoicingHighElement(n) == null) {
            this.musicRepresentation.update(MusicRepresentation.Type.Chord, musicElement2, n);
        }
        musicElement2.setEvidence(musicElement2.getHighestProbIndex());
        System.err.println(" <<< " + musicElement2.getLabel(musicElement2.getHighestProbIndex()));
        int[] nArray = new int[]{this.musicRepresentation.getVoicingHighElement(n).getHighestProbIndex(), this.musicRepresentation.getVoicingMidHighElement(n).getHighestProbIndex(), this.musicRepresentation.getVoicingMidLowElement(n).getHighestProbIndex(), this.musicRepresentation.getVoicingLowElement(n).getHighestProbIndex()};
        Iterator<ShortMessageEvent> iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            for (int n2 : nArray) {
                ShortMessageEvent shortMessageEvent = iterator.next();
                try {
                    ShortMessage shortMessage = new ShortMessage();
                    shortMessage.setMessage(shortMessageEvent.sm.getStatus(), n2, shortMessageEvent.sm.getData2());
                    track.add(new MidiEvent(shortMessage, shortMessageEvent.tick + l));
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    invalidMidiDataException.printStackTrace();
                }
            }
        }
        Object object = this.channelTen.iterator();
        while (object.hasNext()) {
            ShortMessageEvent shortMessageEvent = (ShortMessageEvent)object.next();
            try {
                ShortMessage shortMessage = new ShortMessage();
                shortMessage.setMessage(shortMessageEvent.sm.getStatus(), shortMessageEvent.sm.getData1(), shortMessageEvent.sm.getData2());
                track.add(new MidiEvent(shortMessage, shortMessageEvent.tick + l));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (int i = 0; i < 4; ++i) {
            int n3 = this.musicRepresentation.getBassElement(n + i * 2).getHighestProbIndex();
            try {
                ShortMessage shortMessage = new ShortMessage();
                shortMessage.setMessage(144, 2, n3, this.VELOCITY);
                track.add(new MidiEvent(shortMessage, l + (long)(i * SequencerManager.TICKS_PER_BEAT)));
                shortMessage = new ShortMessage();
                shortMessage.setMessage(128, 2, n3, this.VELOCITY);
                track.add(new MidiEvent(shortMessage, l + (long)((i + 1) * SequencerManager.TICKS_PER_BEAT)));
                continue;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
            }
        }
        return true;
    }

    private class ShortMessageEvent {
        ShortMessage sm;
        long tick;

        ShortMessageEvent(ShortMessage shortMessage, long l) {
            this.sm = shortMessage;
            this.tick = l;
        }
    }
}

