/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPDoubleArray;
import jp.crestmuse.cmx.amusaj.sp.SPDummyObject;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowSlider
extends SPModule<SPDummyObject, SPDoubleArray> {
    private int winsize = 0;
    private double shift = Double.NaN;
    private int shift_;
    private int chTarget = 0;
    private double[] buff;
    private int fs;
    private DoubleArray wavM = null;
    private DoubleArray wavL = null;
    private DoubleArray wavR = null;
    private boolean isStereo;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private int t = 0;

    @Override
    protected String getParamCategory() {
        return "fft";
    }

    @Override
    protected String[] getUsedParamNames() {
        return new String[]{"WINDOW_SIZE", "SHIFT"};
    }

    public void setInputData(AudioDataCompatible audioDataCompatible) {
        this.winsize = this.getParamInt("WINDOW_SIZE");
        int n = audioDataCompatible.channels();
        this.setParam("CHANNELS", n);
        this.fs = audioDataCompatible.sampleRate();
        this.setParam("SAMPLE_RATE", this.fs);
        this.shift = this.getParamDouble("SHIFT");
        if (this.shift < 1.0) {
            this.shift *= (double)this.fs;
        }
        this.shift_ = (int)this.shift;
        DoubleArray[] doubleArrayArray = audioDataCompatible.getDoubleArrayWaveform();
        if (!this.containsParam("TARGET_CHANNEL")) {
            if (n == 2) {
                this.setParam("TARGET_CHANNEL", "stereo");
            } else {
                this.setParam("TARGET_CHANNEL", "0");
            }
        }
        if (n == 2 && this.getParam("TARGET_CHANNEL").equalsIgnoreCase("mix")) {
            this.wavM = Operations.add(doubleArrayArray[0], doubleArrayArray[1]);
            Operations.divX(this.wavM, 2.0);
            this.setWaveform(this.wavM, null, null, false);
        } else if (n == 2 && this.getParam("TARGET_CHANNEL").equalsIgnoreCase("stereo")) {
            this.wavM = Operations.add(doubleArrayArray[0], doubleArrayArray[1]);
            Operations.divX(this.wavM, 2.0);
            this.setWaveform(this.wavM, doubleArrayArray[0], doubleArrayArray[1], true);
        } else {
            try {
                this.setWaveform(doubleArrayArray[this.getParamInt("TARGET_CHANNEL")], null, null, false);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("TARGET_CHANNEL should be an integer, 'mix', or 'stereo'.");
            }
        }
        this.t = 0;
    }

    private void setWaveform(DoubleArray doubleArray, DoubleArray doubleArray2, DoubleArray doubleArray3, boolean bl) {
        this.wavM = doubleArray;
        this.wavL = doubleArray2;
        this.wavR = doubleArray3;
        this.isStereo = bl;
    }

    @Override
    public int getInputChannels() {
        return 0;
    }

    @Override
    public int getOutputChannels() {
        return 3;
    }

    public int getTimeUnit() {
        return 1000 * this.shift_ / this.fs;
    }

    @Override
    public void execute(List<QueueReader<SPDummyObject>> list, List<TimeSeriesCompatible<SPDoubleArray>> list2) throws InterruptedException {
        boolean bl = this.t + this.shift_ + this.winsize < this.wavM.length();
        SPDoubleArray sPDoubleArray = new SPDoubleArray(this.wavM.subarrayX(this.t, this.t + this.winsize), bl);
        list2.get(0).add(sPDoubleArray);
        if (this.isStereo) {
            list2.get(1).add(new SPDoubleArray(this.wavL.subarrayX(this.t, this.t + this.winsize), bl));
            list2.get(2).add(new SPDoubleArray(this.wavR.subarrayX(this.t, this.t + this.winsize), bl));
        } else {
            list2.get(1).add(sPDoubleArray);
            list2.get(2).add(sPDoubleArray);
        }
        this.t += this.shift_;
    }
}

