/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import org.xml.sax.SAXException;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.EditableBayesNet;
import weka.classifiers.bayes.net.MarginCalculator;
import weka.core.Instances;
import weka.core.SerializedObject;

public class BayesNetWrapper
implements FileWrapperCompatible {
    private EditableBayesNet bayesNet;
    private String fileName;

    public BayesNetWrapper(String string) {
        this.fileName = string;
        try {
            if (this.isArff(string)) {
                Instances instances = new Instances((Reader)new FileReader(string));
                this.bayesNet = new EditableBayesNet(instances);
                this.bayesNet.buildClassifier(instances);
            } else {
                BIFReader bIFReader = new BIFReader();
                bIFReader.processFile(string);
                this.bayesNet = new EditableBayesNet(bIFReader);
            }
            this.update();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addNode(String string, int n) {
        try {
            this.bayesNet.addNode(string, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteNode(int n) {
        try {
            this.bayesNet.deleteNode(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteNode(String string) {
        try {
            this.bayesNet.deleteNode(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addArc(int n, int n2) {
        try {
            this.bayesNet.addArc(n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addArc(String string, String string2) {
        try {
            this.bayesNet.addArc(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addNodeValue(int n, String string) {
        this.bayesNet.addNodeValue(n, string);
    }

    public void delNodeValue(int n, String string) {
        try {
            this.bayesNet.delNodeValue(n, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void renameNodeValue(int n, String string, String string2) {
        this.bayesNet.renameNodeValue(n, string, string2);
    }

    public double[] getMargin(int n) {
        return this.bayesNet.getMargin(n);
    }

    public void setMargin(int n, double[] dArray) {
        this.bayesNet.setMargin(n, dArray);
    }

    public String getValueName(int n, int n2) {
        return this.bayesNet.getValueName(n, n2);
    }

    public int getHighestMarginIndex(int n) {
        double d = 0.0;
        int n2 = 0;
        double[] dArray = this.bayesNet.getMargin(n);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            n2 = i;
        }
        return n2;
    }

    public String getHighestMarginName(int n) {
        return this.bayesNet.getValueName(n, this.getHighestMarginIndex(n));
    }

    public String getRankedMarginName(int n, int n2) {
        int n3;
        double[] dArray = this.bayesNet.getMargin(n);
        int n4 = 0;
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        dArray2 = (double[])dArray.clone();
        Arrays.sort(dArray2);
        for (n3 = 0; n3 < dArray.length; ++n3) {
            dArray3[n3] = dArray2[dArray.length - n3 - 1];
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            if (dArray[n3] != dArray3[n2 - 1]) continue;
            n4 = n3;
            break;
        }
        return this.bayesNet.getValueName(n, n4);
    }

    public int getEvidence(int n) {
        return this.bayesNet.getEvidence(n);
    }

    public void setEvidence(int n, int n2) {
        this.bayesNet.setEvidence(n, n2);
    }

    public void setEvidence(int n, String string) {
        String[] stringArray = this.bayesNet.getValues(n);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            this.bayesNet.setEvidence(n, i);
            break;
        }
    }

    public void update() {
        try {
            int n;
            MarginCalculator marginCalculator = new MarginCalculator();
            marginCalculator.calcMargins((BayesNet)this.bayesNet);
            SerializedObject serializedObject = new SerializedObject((Object)marginCalculator);
            MarginCalculator marginCalculator2 = (MarginCalculator)serializedObject.getObject();
            for (n = 0; n < this.bayesNet.getNrOfNodes(); ++n) {
                if (this.bayesNet.getEvidence(n) < 0) continue;
                marginCalculator2.setEvidence(n, this.bayesNet.getEvidence(n));
            }
            for (n = 0; n < this.bayesNet.getNrOfNodes(); ++n) {
                this.bayesNet.setMargin(n, marginCalculator2.getMargin(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void write(OutputStream outputStream) throws IOException, SAXException {
        outputStream.write(this.bayesNet.toXMLBIF03().getBytes());
        outputStream.close();
    }

    public void write(Writer writer) throws IOException, SAXException {
        writer.write(this.bayesNet.toXMLBIF03());
        writer.close();
    }

    public void writeGZippedFile(File file) throws IOException, SAXException {
        this.writefile(file);
    }

    public void writefile(File file) throws IOException, SAXException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.write(fileOutputStream);
        fileOutputStream.close();
    }

    private boolean isArff(String string) {
        return string.substring(string.lastIndexOf(".") + 1).equals("arff");
    }

    public static void main(String[] stringArray) {
        BayesNetWrapper bayesNetWrapper = new BayesNetWrapper("hoge.xml");
        bayesNetWrapper.setEvidence(0, 0);
        bayesNetWrapper.setEvidence(1, "G#");
        bayesNetWrapper.setEvidence(2, 0);
        bayesNetWrapper.update();
        System.out.println(bayesNetWrapper.getHighestMarginName(3));
    }
}

