/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.commands.ChordConverter;
import jp.crestmuse.cmx.amusaj.filewrappers.ArffWrapper;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCC2ARFF080731
extends CMXCommand<FileWrapperCompatible, FileWrapperCompatible> {
    private ArffWrapper arff = new ArffWrapper("chord");

    SCC2ARFF080731() {
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
        String[] stringArray2 = new String[]{"A", "A#", "A#aug", "A#dim", "A#m", "Aaug", "Adim", "Am", "B", "Baug", "Bdim", "Bm", "C", "C#", "C#aug", "C#dim", "C#m", "Caug", "Cdim", "Cm", "D", "D#", "D#aug", "D#dim", "D#m", "Daug", "Ddim", "Dm", "E", "Eaug", "Edim", "Em", "F", "F#", "F#aug", "F#dim", "F#m", "Faug", "Fdim", "Fm", "G", "G#", "G#aug", "G#dim", "G#m", "Gaug", "Gdim", "Gm"};
        this.arff.addAttribute("PrevNote", stringArray);
        this.arff.addAttribute("PrevChord", stringArray2);
        this.arff.addAttribute("CurrentNote", stringArray);
        this.arff.addAttribute("CurrentChord", stringArray2);
        this.arff.addAttribute("NextNote", stringArray);
        this.arff.addAttribute("NextChord", stringArray2);
    }

    @Override
    protected FileWrapperCompatible run(FileWrapperCompatible fileWrapperCompatible) throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)fileWrapperCompatible;
        ChordConverter chordConverter = new ChordConverter();
        int n = -1;
        String string = null;
        int n2 = -1;
        String string2 = null;
        String string3 = "UNDEFINED";
        for (int i = 0; i < sCCXMLWrapper.getHeaderElementList().length; ++i) {
            if (!sCCXMLWrapper.getHeaderElementList()[i].name().equals("KEY")) continue;
            string3 = chordConverter.getPrefix(sCCXMLWrapper.getHeaderElementList()[i].content());
            break;
        }
        if (string3.equals("UNDEFINED")) {
            System.out.println(fileWrapperCompatible + " is invalid musickey");
            return null;
        }
        for (SCCXMLWrapper.Annotation annotation : sCCXMLWrapper.getChordList()) {
            String string4 = annotation.content();
            if (string4.equals("D'")) continue;
            int n3 = -1;
            for (SCCXMLWrapper.Note note : sCCXMLWrapper.getPartList()[0].getNoteList()) {
                if (note.onset() < annotation.onset()) continue;
                n3 = note.notenum() % 12;
                break;
            }
            if (n3 == -1) {
                return null;
            }
            n3 = chordConverter.noteTransfer(string3, n3);
            if ((string4 = chordConverter.chordOmitter(chordConverter.chordTransfer(string3, string4))).equals("/")) {
                string4 = string2;
            }
            if (!(string2 == null || string == null || n == -1 || string.matches(chordConverter.ignore_chords) || string2.matches(chordConverter.ignore_chords) || string4.matches(chordConverter.ignore_chords))) {
                this.arff.addData(n + "," + string + "," + n2 + "," + string2 + "," + n3 + "," + string4);
            }
            n = n2;
            n2 = -1;
            for (SCCXMLWrapper.Note note : sCCXMLWrapper.getPartList()[0].getNoteList()) {
                if (note.onset() >= annotation.offset()) break;
                n2 = note.notenum();
            }
            if (n2 == -1) {
                return null;
            }
            n2 %= 12;
            string = string2;
            string2 = string4;
        }
        return null;
    }

    @Override
    protected void postproc() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File("hoge.arff"));
        this.arff.write(fileOutputStream);
    }

    public static void main(String[] stringArray) {
        SCC2ARFF080731 sCC2ARFF080731 = new SCC2ARFF080731();
        try {
            sCC2ARFF080731.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

