/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.Arrays;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.FeatureExtractor;
import jp.crestmuse.cmx.amusaj.sp.SPDoubleArray;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureExtractionModule
extends SPModule {
    private FeatureExtractor fe;

    public FeatureExtractionModule(FeatureExtractor featureExtractor) {
        this.fe = featureExtractor;
    }

    @Override
    public void execute(SPElement[] sPElementArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) throws InterruptedException {
        SPDoubleArray sPDoubleArray = (SPDoubleArray)sPElementArray[0];
        int n = timeSeriesCompatibleArray.length;
        this.fe.extractFeatures(sPDoubleArray);
        for (int i = 0; i < n; ++i) {
            TimeSeriesCompatible<SPElement> timeSeriesCompatible = timeSeriesCompatibleArray[i];
            timeSeriesCompatible.add(new SPDoubleArray(this.fe.getFeature(i)));
            timeSeriesCompatible.setAttribute("type", this.fe.getFeatureType(i));
        }
        this.fe.nextFrame();
    }

    @Override
    public Class<SPElement>[] getInputClasses() {
        return new Class[]{SPDoubleArray.class};
    }

    @Override
    public Class<SPElement>[] getOutputClasses() {
        Object[] objectArray = new Class[this.fe.nFeatureTypes()];
        Arrays.fill(objectArray, SPDoubleArray.class);
        return objectArray;
    }
}

