/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;

public class CheckSource
implements OptionHandler {
    protected Filter m_Filter = null;
    protected Filter m_SourceCode = null;
    protected File m_Dataset = null;
    protected int m_ClassIndex = -1;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe filter (incl. options) that was used to generate\n\tthe source code.", "W", 1, "-W <classname and options>"));
        vector.addElement(new Option("\tThe classname of the generated source code.", "S", 1, "-S <classname>"));
        vector.addElement(new Option("\tThe training set with which the source code was generated.", "t", 1, "-t <file>"));
        vector.addElement(new Option("\tThe class index of the training set. 'first' and 'last' are\n\tvalid indices.\n\t(default: none)", "c", 1, "-c <index>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
        } else {
            throw new Exception("No filter (classname + options) provided!");
        }
        String string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setFilter((Filter)Utils.forName(Filter.class, string2, stringArray2));
        string = Utils.getOption('S', stringArray);
        if (string.length() > 0) {
            stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length != 1) {
                throw new IllegalArgumentException("Invalid source code specification string");
            }
        } else {
            throw new Exception("No source code (classname) provided!");
        }
        string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setSourceCode((Filter)Utils.forName(Filter.class, string2, stringArray2));
        string = Utils.getOption('t', stringArray);
        if (string.length() == 0) {
            throw new Exception("No dataset provided!");
        }
        this.setDataset(new File(string));
        string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            if (string.equals("first")) {
                this.setClassIndex(0);
            } else if (string.equals("last")) {
                this.setClassIndex(-2);
            } else {
                this.setClassIndex(Integer.parseInt(string) - 1);
            }
        } else {
            this.setClassIndex(-1);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getFilter() != null) {
            vector.add("-W");
            vector.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()));
        }
        if (this.getSourceCode() != null) {
            vector.add("-S");
            vector.add(this.getSourceCode().getClass().getName());
        }
        if (this.getDataset() != null) {
            vector.add("-t");
            vector.add(this.m_Dataset.getAbsolutePath());
        }
        if (this.getClassIndex() != -1) {
            vector.add("-c");
            if (this.getClassIndex() == -2) {
                vector.add("last");
            } else if (this.getClassIndex() == 0) {
                vector.add("first");
            } else {
                vector.add("" + (this.getClassIndex() + 1));
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public void setSourceCode(Filter filter) {
        this.m_SourceCode = filter;
    }

    public Filter getSourceCode() {
        return this.m_SourceCode;
    }

    public void setDataset(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Dataset '" + file.getAbsolutePath() + "' does not exist!");
        }
        this.m_Dataset = file;
    }

    public File getDataset() {
        return this.m_Dataset;
    }

    public void setClassIndex(int n) {
        this.m_ClassIndex = n;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    protected boolean compare(Instance instance, Instance instance2) {
        boolean bl;
        boolean bl2 = bl = instance.numAttributes() == instance2.numAttributes();
        if (bl) {
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (Double.isNaN(instance.value(i)) && Double.isNaN(instance2.value(i)) || instance.value(i) == instance2.value(i)) continue;
                bl = false;
                System.out.println("Values at position " + (i + 1) + " differ (Filter/Source code): " + instance.value(i) + " != " + instance2.value(i));
                break;
            }
        }
        return bl;
    }

    protected boolean compare(Instances instances, Instances instances2) {
        boolean bl;
        boolean bl2 = bl = instances.numInstances() == instances2.numInstances();
        if (bl) {
            for (int i = 0; i < instances.numInstances(); ++i) {
                bl = this.compare(instances.instance(i), instances2.instance(i));
                if (bl) continue;
                System.out.println("Values in line " + (i + 1) + " differ!");
                break;
            }
        }
        return bl;
    }

    public boolean execute() throws Exception {
        boolean bl = true;
        if (this.getFilter() == null) {
            throw new Exception("No filter set!");
        }
        if (this.getSourceCode() == null) {
            throw new Exception("No source code set!");
        }
        if (this.getDataset() == null) {
            throw new Exception("No dataset set!");
        }
        if (!this.getDataset().exists()) {
            throw new Exception("Dataset '" + this.getDataset().getAbsolutePath() + "' does not exist!");
        }
        ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(this.getDataset().getAbsolutePath());
        Instances instances = dataSource.getDataSet();
        if (this.getClassIndex() == -2) {
            instances.setClassIndex(instances.numAttributes() - 1);
        } else {
            instances.setClassIndex(this.getClassIndex());
        }
        Filter filter = Filter.makeCopy(this.getFilter());
        filter.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, filter);
        Filter filter2 = Filter.makeCopy(this.getSourceCode());
        filter2.setInputFormat(instances);
        Instances instances3 = Filter.useFilter(instances, filter2);
        bl = this.compare(instances2, instances3);
        if (bl) {
            filter = Filter.makeCopy(this.getFilter());
            filter.setInputFormat(instances);
            Filter.useFilter(instances, filter);
            filter2 = Filter.makeCopy(this.getSourceCode());
            filter2.setInputFormat(instances);
            for (int i = 0; i < instances.numInstances(); ++i) {
                filter.input(instances.instance(i));
                filter.batchFinished();
                Instance instance = filter.output();
                filter2.input(instances.instance(i));
                filter2.batchFinished();
                Instance instance2 = filter2.output();
                if (this.compare(instance, instance2)) continue;
                System.out.println(i + 1 + ". instance (Filter/Source code): " + instance + " != " + instance2);
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        CheckSource checkSource = new CheckSource();
        if (Utils.getFlag('h', stringArray)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\nHelp requested:\n\n");
            Enumeration enumeration = checkSource.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + "\n");
                stringBuffer.append(option.description() + "\n");
            }
            System.out.println("\n" + stringBuffer + "\n");
        } else {
            checkSource.setOptions(stringArray);
            if (checkSource.execute()) {
                System.out.println("Tests OK!");
            } else {
                System.out.println("Tests failed!");
            }
        }
    }
}

