/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.commands.ModuleConnection;
import jp.crestmuse.cmx.amusaj.commands.OutputData;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.FeatureExtractionModule2;
import jp.crestmuse.cmx.amusaj.sp.HarmonicsExtractor2;
import jp.crestmuse.cmx.amusaj.sp.HarmonicsTimeSeriesGenerator;
import jp.crestmuse.cmx.amusaj.sp.KitaharaFeatureExtractor;
import jp.crestmuse.cmx.amusaj.sp.PeakExtractor;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.SPSpreadModule;
import jp.crestmuse.cmx.amusaj.sp.STFT;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;

public class WAV2TBD
extends AbstractWAVAnalyzer {
    private boolean paramSet = false;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private ProducerConsumerCompatible stft;
    private ProducerConsumerCompatible peakext;
    private ProducerConsumerCompatible spread;

    protected boolean setOptionsLocal(String string, String string2) {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (string.equals("-from") || string.equals("-f")) {
            amusaParameterSet.setParam("feature", "NOTENUMBER_FROM", String.valueOf(string2));
            return true;
        }
        if (string.equals("-thru") || string.equals("-t")) {
            amusaParameterSet.setParam("feature", "NOTENUMBER_THRU", String.valueOf(string2));
            return true;
        }
        if (string.equals("-step")) {
            amusaParameterSet.setParam("feature", "STEP", String.valueOf(string2));
            return true;
        }
        return false;
    }

    protected ProducerConsumerCompatible[] getUsedModules() {
        int n = this.getParamInt("feature", "NOTENUMBER_FROM");
        int n2 = this.getParamInt("feature", "NOTENUMBER_THRU");
        double d = this.getParamDouble("feature", "STEP");
        int n3 = (int)((double)(n2 - n) * d);
        System.err.println(n3);
        this.stft = new STFT(this.usesStereo());
        return new ProducerConsumerCompatible[]{this.stft, this.peakext = new PeakExtractor(), this.spread = new SPSpreadModule(PeakSet.class, n3)};
    }

    protected ModuleConnection[] getModuleConnections() {
        return new ModuleConnection[]{new ModuleConnection(this.getWindowSlider(), 0, this.stft, 0), new ModuleConnection(this.stft, 0, this.peakext, 0), new ModuleConnection(this.stft, 1, this.peakext, 1), new ModuleConnection(this.stft, 2, this.peakext, 2), new ModuleConnection(this.peakext, 0, this.spread, 0)};
    }

    protected void customSetting(SPExecutor sPExecutor, AmusaDataSetCompatible amusaDataSetCompatible) {
        int n = this.getParamInt("feature", "NOTENUMBER_FROM");
        int n2 = this.getParamInt("feature", "NOTENUMBER_THRU");
        double d = this.getParamDouble("feature", "STEP");
        int n3 = (int)((double)(n2 - n) * d);
        System.err.println(n3);
        for (int i = 0; i < n3; ++i) {
            double d2 = Operations.nn2Hz((double)n + d * (double)i);
            HarmonicsExtractor2 harmonicsExtractor2 = new HarmonicsExtractor2(d2);
            sPExecutor.addSPModule(harmonicsExtractor2);
            sPExecutor.connect(this.spread, i, harmonicsExtractor2, 0);
            HarmonicsTimeSeriesGenerator harmonicsTimeSeriesGenerator = new HarmonicsTimeSeriesGenerator();
            sPExecutor.addSPModule(harmonicsTimeSeriesGenerator);
            sPExecutor.connect(harmonicsExtractor2, 0, harmonicsTimeSeriesGenerator, 0);
            FeatureExtractionModule2 featureExtractionModule2 = new FeatureExtractionModule2(new KitaharaFeatureExtractor(3, 10));
            sPExecutor.addSPModule(featureExtractionModule2);
            sPExecutor.connect(harmonicsTimeSeriesGenerator, 0, featureExtractionModule2, 0);
            TimeSeriesCompatible timeSeriesCompatible = sPExecutor.getResult(featureExtractionModule2).get(0);
            timeSeriesCompatible.setAttribute("notenum", (double)n + d * (double)i);
            amusaDataSetCompatible.add(timeSeriesCompatible);
        }
    }

    protected String getAmusaXMLFormat() {
        return "array";
    }

    protected OutputData[] getOutputData() {
        return new OutputData[0];
    }

    public static void main(String[] stringArray) {
        WAV2TBD wAV2TBD = new WAV2TBD();
        try {
            wAV2TBD.start(stringArray);
        }
        catch (Exception exception) {
            wAV2TBD.showErrorMessage(exception);
            System.exit(1);
        }
    }

    static {
        WAV2TBD.addOptionHelpMessage("-f <nn>", "lower bound note number for analysis");
        WAV2TBD.addOptionHelpMessage("-t <nn>", "uppper bound note number for analysis");
        WAV2TBD.addOptionHelpMessage("-step <nn>", "");
    }
}

