/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.commands.ModuleConnection;
import jp.crestmuse.cmx.amusaj.commands.OptionUtils;
import jp.crestmuse.cmx.amusaj.commands.OutputData;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculatorModule;
import jp.crestmuse.cmx.amusaj.sp.PeakExtractor;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.STFT;
import jp.crestmuse.cmx.math.DoubleArrayFactory;

public class WAV2FPD
extends AbstractWAVAnalyzer {
    private boolean paramSet = false;
    private ProducerConsumerCompatible stft;
    private ProducerConsumerCompatible peakext;
    private ProducerConsumerCompatible f0calc;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    protected boolean setOptionsLocal(String string, String string2) {
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        return OptionUtils.setF0PDFOptions(string, string2);
    }

    protected ProducerConsumerCompatible[] getUsedModules() {
        this.stft = new STFT(this.usesStereo());
        return new ProducerConsumerCompatible[]{this.stft, this.peakext = new PeakExtractor(), this.f0calc = new F0PDFCalculatorModule()};
    }

    protected ModuleConnection[] getModuleConnections() {
        return new ModuleConnection[]{new ModuleConnection(this.getWindowSlider(), 0, this.stft, 0), new ModuleConnection(this.stft, 0, this.peakext, 0), new ModuleConnection(this.stft, 1, this.peakext, 1), new ModuleConnection(this.stft, 2, this.peakext, 2), new ModuleConnection(this.peakext, 0, this.f0calc, 0)};
    }

    protected String getAmusaXMLFormat() {
        return "array";
    }

    protected OutputData[] getOutputData() {
        return new OutputData[]{new OutputData(this.f0calc, 0)};
    }

    public static void main(String[] stringArray) {
        WAV2FPD wAV2FPD = new WAV2FPD();
        try {
            wAV2FPD.start(stringArray);
        }
        catch (Exception exception) {
            wAV2FPD.showErrorMessage(exception);
            System.exit(1);
        }
    }

    static {
        WAV2FPD.addOptionHelpMessage("-f <nn>", "lower bound note number for analysis");
        WAV2FPD.addOptionHelpMessage("-t <nn>", "uppper bound note number for analysis");
        WAV2FPD.addOptionHelpMessage("-step <nn>", "");
        WAV2FPD.addOptionHelpMessage("-filter <filter_name>", "filter used in calculating F0PDF");
    }
}

