/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
 package jp.sourceforge.manganetwork.page;

import javax.persistence.EntityManager;

import jp.sourceforge.manganetwork.dao.EMF;
import jp.sourceforge.manganetwork.model.Book;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.PropertyModel;

public class BookRegistPage extends MenuApplicationPage {
	private Book book;	
	
	public BookRegistPage()
	{
		book = new Book();
		add(createForm());
	}

	private Form createForm() {
		Form form = new Form("form")
		{

			@Override
			protected void onSubmit() {

				EntityManager em = EMF.get().createEntityManager();
				em.persist(book);
				em.close();
				
				super.onSubmit();
			}
			
		};
		
		form.add(new TextField("bookName", new PropertyModel(book, "name")));
		return form;
	}
}

