/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.MethodSignature;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedMember;
import org.jboss.webbeans.introspector.jlr.AnnotatedParameterImpl;
import org.jboss.webbeans.introspector.jlr.MethodSignatureImpl;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.collections.multi.ListHashMultiMap;
import org.jboss.webbeans.util.collections.multi.ListMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedMethodImpl<T>
extends AbstractAnnotatedMember<T, Method>
implements AnnotatedMethod<T> {
    private final Method method;
    private final List<AnnotatedParameter<?>> parameters;
    private final ListMultiMap<Class<? extends Annotation>, AnnotatedParameter<?>> annotatedParameters;
    private final String propertyName;
    private final AnnotatedType<?> declaringClass;
    private String toString;
    private final MethodSignature signature;

    public static <T> AnnotatedMethodImpl<T> of(Method method, AnnotatedType<?> declaringClass) {
        return new AnnotatedMethodImpl<T>(method, declaringClass);
    }

    protected AnnotatedMethodImpl(Method method, AnnotatedType<?> declaringClass) {
        super(AnnotationStore.of(method), method, method.getReturnType(), method.getGenericReturnType());
        this.method = method;
        this.method.setAccessible(true);
        this.declaringClass = declaringClass;
        this.parameters = new ArrayList();
        this.annotatedParameters = new ListHashMultiMap();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            AnnotatedParameter<?> parameter;
            Type type;
            Class<?> clazz;
            if (method.getParameterAnnotations()[i].length > 0) {
                clazz = method.getParameterTypes()[i];
                type = method.getGenericParameterTypes()[i];
                parameter = AnnotatedParameterImpl.of(method.getParameterAnnotations()[i], clazz, type, this);
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotationsAsSet()) {
                    if (!MAPPED_PARAMETER_ANNOTATIONS.contains(annotation.annotationType())) continue;
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = method.getParameterTypes()[i];
            type = method.getGenericParameterTypes()[i];
            parameter = AnnotatedParameterImpl.of(new Annotation[0], clazz, type, this);
            this.parameters.add(parameter);
        }
        String propertyName = Reflections.getPropertyName(this.getDelegate());
        this.propertyName = propertyName == null ? this.getName() : propertyName;
        this.signature = new MethodSignatureImpl(this);
    }

    @Override
    public Method getAnnotatedMethod() {
        return this.method;
    }

    @Override
    public Method getDelegate() {
        return this.method;
    }

    @Override
    public List<AnnotatedParameter<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Class<?>[] getParameterTypesAsArray() {
        return this.method.getParameterTypes();
    }

    @Override
    public List<AnnotatedParameter<?>> getAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList((List)this.annotatedParameters.get(annotationType));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AnnotatedMethod) {
            AnnotatedMethod that = (AnnotatedMethod)other;
            return this.getDeclaringClass().equals(that.getDeclaringClass()) && this.getName().equals(that.getName()) && ((Object)this.getParameters()).equals(that.getParameters());
        }
        return false;
    }

    @Override
    public boolean isEquivalent(Method method) {
        return this.getDeclaringClass().isEquivalent(method.getDeclaringClass()) && this.getName().equals(method.getName()) && Arrays.equals(this.getParameterTypesAsArray(), method.getParameterTypes());
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public T invokeOnInstance(Object instance, Object ... parameters) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = Reflections.lookupMethod(this.getName(), this.getParameterTypesAsArray(), instance);
        Object result = method.invoke(instance, parameters);
        return (T)result;
    }

    @Override
    public T invoke(Object instance, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object result = this.method.invoke(instance, parameters);
        return (T)result;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public AnnotatedType<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated method on class " + this.getDeclaringClass().getName() + Names.methodToString(this.method);
        return this.toString;
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }
}

