/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.conversation;

import javax.annotation.Named;
import javax.context.Conversation;
import javax.context.RequestScoped;
import javax.inject.Initializer;
import javax.inject.Standard;
import org.jboss.webbeans.conversation.ConversationIdGenerator;
import org.jboss.webbeans.conversation.ConversationInactivityTimeout;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

@RequestScoped
@Named(value="javax.context.conversation")
@Standard
public class ConversationImpl
implements Conversation {
    private static LogProvider log = Logging.getLogProvider(ConversationImpl.class);
    private String cid;
    private String originalCid;
    private boolean longRunning;
    private long timeout;

    public ConversationImpl() {
    }

    public ConversationImpl(Conversation conversation) {
        this.cid = conversation.getId();
        this.longRunning = conversation.isLongRunning();
        this.timeout = conversation.getTimeout();
    }

    @Initializer
    public void init(ConversationIdGenerator conversationIdGenerator, @ConversationInactivityTimeout long timeout) {
        this.cid = conversationIdGenerator.nextId();
        this.timeout = timeout;
        this.longRunning = false;
        log.debug("Created a new conversation " + this);
    }

    public void begin() {
        log.debug("Promoted conversation " + this.cid + " to long-running");
        this.longRunning = true;
    }

    public void begin(String id) {
        if (this.originalCid == null) {
            this.originalCid = this.cid;
        }
        this.cid = id;
        this.begin();
    }

    public void end() {
        log.debug("Demoted conversation " + this.cid + " to transient");
        this.longRunning = false;
    }

    public String getId() {
        return this.cid;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isLongRunning() {
        return this.longRunning;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void switchTo(Conversation conversation) {
        log.debug("Switched conversation from " + this);
        this.cid = conversation.getId();
        this.longRunning = conversation.isLongRunning();
        this.timeout = conversation.getTimeout();
        log.debug(" to " + this);
    }

    public String toString() {
        return "ID: " + this.cid + ", long-running: " + this.longRunning + ", timeout: " + this.timeout + "ms";
    }

    public void setLongRunning(boolean longRunning) {
        log.debug("Set conversation " + this.cid + " to long-running: " + longRunning);
        this.longRunning = longRunning;
    }

    public String getOriginalCid() {
        return this.originalCid;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Conversation)) {
            return false;
        }
        String otherCid = ((Conversation)obj).getId();
        return this.cid == null || otherCid == null ? false : this.cid.equals(otherCid);
    }

    public int hashCode() {
        return this.cid == null ? super.hashCode() : this.cid.hashCode();
    }
}

