/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class RenameUtil
extends ContextAwareBase {
    static final int BUF_SIZE = 32768;

    public void rename(String from, String to) throws RolloverFailure {
        if (from.equals(to)) {
            this.addWarn("From and to file are the same [" + from + "]. Skipping.");
            return;
        }
        File fromFile = new File(from);
        if (fromFile.exists()) {
            File toFile = new File(to);
            this.addInfo("Renaming file [" + fromFile + "] to [" + toFile + "]");
            boolean result = fromFile.renameTo(toFile);
            if (!result) {
                this.addWarn("Failed to rename file [" + fromFile + "] to [" + toFile + "].");
                this.addWarn("Attempting to rename by copying.");
                this.renameByCopying(from, to);
            }
        } else {
            throw new RolloverFailure("File [" + from + "] does not exist.");
        }
    }

    public void renameByCopying(String from, String to) throws RolloverFailure {
        try {
            int n;
            FileInputStream fis = new FileInputStream(from);
            FileOutputStream fos = new FileOutputStream(to);
            byte[] inbuf = new byte[32768];
            while ((n = fis.read(inbuf)) != -1) {
                fos.write(inbuf, 0, n);
            }
            fis.close();
            fos.close();
            File fromFile = new File(from);
            if (!fromFile.delete()) {
                this.addWarn("Could not delete " + from);
            }
        }
        catch (IOException ioe) {
            this.addError("Failed to rename file by copying", ioe);
            throw new RolloverFailure("Failed to rename file by copying");
        }
    }

    public String toString() {
        return "c.q.l.co.rolling.helper.RenameUtil";
    }
}

