/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.protocol.http.MockHttpServletRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.tester.BaseWicketTester;

public class FormTester {
    private final ChoiceSelectorFactory choiceSelectorFactory = new ChoiceSelectorFactory();
    private boolean closed = false;
    private final String path;
    private final BaseWicketTester baseWicketTester;
    private final Form workingForm;
    static /* synthetic */ Class class$org$apache$wicket$markup$html$form$Radio;
    static /* synthetic */ Class class$org$apache$wicket$markup$html$form$Check;

    protected FormTester(String path, Form workingForm, BaseWicketTester wicketTester, final boolean fillBlankString) {
        this.path = path;
        this.workingForm = workingForm;
        this.baseWicketTester = wicketTester;
        this.baseWicketTester.setupRequestAndResponse();
        workingForm.visitFormComponents(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                Object value;
                if (!formComponent.isVisibleInHierarchy()) {
                    return;
                }
                if (formComponent instanceof AbstractTextComponent) {
                    if (Strings.isEmpty(formComponent.getValue())) {
                        if (fillBlankString) {
                            FormTester.this.setFormComponentValue(formComponent, "");
                        }
                    } else {
                        FormTester.this.setFormComponentValue(formComponent, formComponent.getValue());
                    }
                } else if (formComponent instanceof DropDownChoice || formComponent instanceof RadioChoice || formComponent instanceof CheckBox) {
                    FormTester.this.setFormComponentValue(formComponent, formComponent.getValue());
                } else if (formComponent instanceof ListMultipleChoice) {
                    String[] modelValues = formComponent.getValue().split(FormComponent.VALUE_SEPARATOR);
                    for (int i = 0; i < modelValues.length; ++i) {
                        FormTester.this.addFormComponentValue(formComponent, modelValues[i]);
                    }
                } else if (formComponent instanceof CheckGroup) {
                    Collection checkGroupValues = (Collection)formComponent.getModelObject();
                    formComponent.visitChildren(class$org$apache$wicket$markup$html$form$Check == null ? (class$org$apache$wicket$markup$html$form$Check = FormTester.class$("org.apache.wicket.markup.html.form.Check")) : class$org$apache$wicket$markup$html$form$Check, new Component.IVisitor(this, checkGroupValues, formComponent){
                        private final /* synthetic */ Collection val$checkGroupValues;
                        private final /* synthetic */ FormComponent val$formComponent;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$checkGroupValues = val$checkGroupValues;
                            this.val$formComponent = val$formComponent;
                        }

                        public Object component(Component component) {
                            if (this.val$checkGroupValues.contains(component.getModelObject())) {
                                FormTester.access$400(1.access$700(this.this$1), this.val$formComponent, ((Check)component).getValue());
                            }
                            return CONTINUE_TRAVERSAL;
                        }
                    });
                } else if (formComponent instanceof RadioGroup && (value = formComponent.getModelObject()) != null) {
                    formComponent.visitChildren(class$org$apache$wicket$markup$html$form$Radio == null ? (class$org$apache$wicket$markup$html$form$Radio = FormTester.class$("org.apache.wicket.markup.html.form.Radio")) : class$org$apache$wicket$markup$html$form$Radio, new Component.IVisitor(this, value, formComponent){
                        private final /* synthetic */ Object val$value;
                        private final /* synthetic */ FormComponent val$formComponent;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$value = val$value;
                            this.val$formComponent = val$formComponent;
                        }

                        public Object component(Component component) {
                            if (this.val$value.equals(component.getModelObject())) {
                                FormTester.access$400(1.access$700(this.this$1), this.val$formComponent, ((Radio)component).getValue());
                                return STOP_TRAVERSAL;
                            }
                            return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                        }
                    });
                }
            }

            static /* synthetic */ FormTester access$700(1 x0) {
                return x0.FormTester.this;
            }
        });
    }

    public Form getForm() {
        return this.workingForm;
    }

    public String getTextComponentValue(String id) {
        Component c = this.getForm().get(id);
        if (c instanceof AbstractTextComponent) {
            return ((AbstractTextComponent)c).getValue();
        }
        return null;
    }

    public void select(String formComponentId, int index) {
        this.checkClosed();
        FormComponent component = (FormComponent)this.workingForm.get(formComponentId);
        ChoiceSelector choiceSelector = this.choiceSelectorFactory.create(component);
        choiceSelector.doSelect(index);
        if (component instanceof DropDownChoice) {
            try {
                Method wantOnSelectionChangedNotificationsMethod = DropDownChoice.class.getDeclaredMethod("wantOnSelectionChangedNotifications", new Class[0]);
                wantOnSelectionChangedNotificationsMethod.setAccessible(true);
                boolean wantOnSelectionChangedNotifications = (Boolean)wantOnSelectionChangedNotificationsMethod.invoke((Object)component, new Object[0]);
                if (wantOnSelectionChangedNotifications) {
                    ((DropDownChoice)component).onSelectionChanged();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void selectMultiple(String formComponentId, int[] indexes) {
        this.checkClosed();
        ChoiceSelector choiceSelector = this.choiceSelectorFactory.createForMultiple((FormComponent)this.workingForm.get(formComponentId));
        for (int i = 0; i < indexes.length; ++i) {
            choiceSelector.doSelect(indexes[i]);
        }
    }

    public void setValue(String formComponentId, String value) {
        this.checkClosed();
        Component component = this.workingForm.get(formComponentId);
        if (component instanceof IFormSubmittingComponent) {
            this.setFormSubmittingComponentValue((IFormSubmittingComponent)((Object)component), value);
        } else if (component instanceof FormComponent) {
            this.setFormComponentValue((FormComponent)component, value);
        }
    }

    public void setFile(String formComponentId, File file, String contentType) {
        this.checkClosed();
        FormComponent formComponent = (FormComponent)this.workingForm.get(formComponentId);
        if (!(formComponent instanceof FileUploadField)) {
            throw new IllegalArgumentException("'" + formComponentId + "' is not " + "a FileUploadField. You can only attach a file to form " + "component of this type.");
        }
        MockHttpServletRequest servletRequest = this.baseWicketTester.getServletRequest();
        servletRequest.addFile(formComponent.getInputName(), file, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit() {
        this.checkClosed();
        try {
            MockHttpServletRequest servletRequest = this.baseWicketTester.getServletRequest();
            WebRequestCycle requestCycle = this.baseWicketTester.createRequestCycle();
            servletRequest.setRequestToComponent(this.workingForm);
            servletRequest.setUseMultiPartContentType(this.isMultiPart());
            this.baseWicketTester.processRequestCycle(requestCycle);
        }
        finally {
            this.closed = true;
        }
    }

    private boolean isMultiPart() {
        try {
            Field multiPart = Form.class.getDeclaredField("multiPart");
            multiPart.setAccessible(true);
            return multiPart.getBoolean(this.workingForm);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void submit(String buttonComponentId) {
        this.setValue(buttonComponentId, "marked");
        this.submit();
    }

    private void addFormComponentValue(FormComponent formComponent, String value) {
        if (this.parameterExist(formComponent)) {
            String[] values = this.baseWicketTester.getServletRequest().getParameterValues(formComponent.getInputName());
            HashSet<String> all = new HashSet<String>(Arrays.asList(values));
            all.add(value);
            HashMap<String, String[]> newParameters = new HashMap<String, String[]>();
            newParameters.put(formComponent.getInputName(), all.toArray(new String[all.size()]));
            this.baseWicketTester.getServletRequest().setParameters(newParameters);
        } else {
            this.setFormComponentValue(formComponent, value);
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("'" + this.path + "' already sumbitted. Note that FormTester " + "is allowed to submit only once");
        }
    }

    private boolean parameterExist(FormComponent formComponent) {
        String parameter = this.baseWicketTester.getServletRequest().getParameter(formComponent.getInputName());
        return parameter != null && parameter.trim().length() > 0;
    }

    private void setFormComponentValue(FormComponent formComponent, String value) {
        this.baseWicketTester.getServletRequest().setParameter(formComponent.getInputName(), value);
    }

    private void setFormSubmittingComponentValue(IFormSubmittingComponent component, String value) {
        this.baseWicketTester.getServletRequest().setParameter(component.getInputName(), value);
    }

    private void fail(String message) {
        throw new WicketRuntimeException(message);
    }

    private class ChoiceSelectorFactory {
        private ChoiceSelectorFactory() {
        }

        protected ChoiceSelector create(FormComponent formComponent) {
            if (formComponent == null) {
                FormTester.this.fail("Trying to select on null component.");
            }
            if (formComponent instanceof RadioGroup || formComponent instanceof DropDownChoice || formComponent instanceof RadioChoice) {
                return new SingleChoiceSelector(formComponent);
            }
            if (this.allowMultipleChoice(formComponent)) {
                return new MultipleChoiceSelector(formComponent);
            }
            FormTester.this.fail("Selecting on the component:'" + formComponent.getPath() + "' is not supported.");
            return null;
        }

        protected ChoiceSelector createForMultiple(FormComponent formComponent) {
            return new MultipleChoiceSelector(formComponent);
        }

        private boolean allowMultipleChoice(FormComponent formComponent) {
            return formComponent instanceof CheckGroup || formComponent instanceof ListMultipleChoice;
        }

        private final class SingleChoiceSelector
        extends ChoiceSelector {
            protected SingleChoiceSelector(FormComponent formComponent) {
                super(formComponent);
            }

            protected void assignValueToFormComponent(FormComponent formComponent, String value) {
                FormTester.this.setFormComponentValue(formComponent, value);
            }
        }

        private final class MultipleChoiceSelector
        extends ChoiceSelector {
            protected MultipleChoiceSelector(FormComponent formComponent) {
                super(formComponent);
                if (!ChoiceSelectorFactory.this.allowMultipleChoice(formComponent)) {
                    FormTester.this.fail("Component:'" + formComponent.getPath() + "' Does not support multiple selection.");
                }
            }

            protected void assignValueToFormComponent(FormComponent formComponent, String value) {
                FormTester.this.addFormComponentValue(formComponent, value);
            }
        }
    }

    protected abstract class ChoiceSelector {
        private final FormComponent formComponent;

        protected ChoiceSelector(FormComponent formComponent) {
            this.formComponent = formComponent;
        }

        protected abstract void assignValueToFormComponent(FormComponent var1, String var2);

        protected final void doSelect(int index) {
            if (this.formComponent instanceof RadioGroup) {
                Radio foundRadio = (Radio)this.formComponent.visitChildren(class$org$apache$wicket$markup$html$form$Radio == null ? (class$org$apache$wicket$markup$html$form$Radio = FormTester.class$("org.apache.wicket.markup.html.form.Radio")) : class$org$apache$wicket$markup$html$form$Radio, new SearchOptionByIndexVisitor(index));
                if (foundRadio == null) {
                    FormTester.this.fail("RadioGroup " + this.formComponent.getPath() + " does not have index:" + index);
                }
                this.assignValueToFormComponent(this.formComponent, foundRadio.getValue());
            } else if (this.formComponent instanceof CheckGroup) {
                Check foundCheck = (Check)this.formComponent.visitChildren(class$org$apache$wicket$markup$html$form$Check == null ? (class$org$apache$wicket$markup$html$form$Check = FormTester.class$("org.apache.wicket.markup.html.form.Check")) : class$org$apache$wicket$markup$html$form$Check, new SearchOptionByIndexVisitor(index));
                if (foundCheck == null) {
                    FormTester.this.fail("CheckGroup " + this.formComponent.getPath() + " does not have index:" + index);
                }
                this.assignValueToFormComponent(this.formComponent, foundCheck.getValue());
            } else {
                String idValue = this.selectAbstractChoice(this.formComponent, index);
                if (idValue == null) {
                    FormTester.this.fail(this.formComponent.getPath() + " is not a selectable Component.");
                } else {
                    this.assignValueToFormComponent(this.formComponent, idValue);
                }
            }
        }

        private String selectAbstractChoice(FormComponent formComponent, int index) {
            try {
                Method getChoicesMethod = formComponent.getClass().getMethod("getChoices", null);
                getChoicesMethod.setAccessible(true);
                List choices = (List)getChoicesMethod.invoke((Object)formComponent, (Object[])null);
                Method getChoiceRendererMethod = formComponent.getClass().getMethod("getChoiceRenderer", null);
                getChoiceRendererMethod.setAccessible(true);
                IChoiceRenderer choiceRenderer = (IChoiceRenderer)getChoiceRendererMethod.invoke((Object)formComponent, (Object[])null);
                return choiceRenderer.getIdValue(choices.get(index), index);
            }
            catch (SecurityException e) {
                throw new WicketRuntimeException("unexpect select failure", e);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                throw new WicketRuntimeException("unexpect select failure", e);
            }
            catch (InvocationTargetException e) {
                throw new WicketRuntimeException("unexpect select failure", e);
            }
        }

        private final class SearchOptionByIndexVisitor
        implements Component.IVisitor {
            int count = 0;
            private final int index;

            private SearchOptionByIndexVisitor(int index) {
                this.index = index;
            }

            public Object component(Component component) {
                if (this.count == this.index) {
                    return component;
                }
                ++this.count;
                return CONTINUE_TRAVERSAL;
            }
        }
    }
}

