/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.io.WicketObjectInputStream;
import org.apache.wicket.util.io.WicketObjectOutputStream;
import org.apache.wicket.util.io.WicketSerializeableException;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public final class ClassStreamHandler {
    private static Unsafe unsafe;
    private static final ReflectionFactory reflFactory;
    private static Map handlesClasses;
    private static short classCounter;
    public static final byte HANDLE = 1;
    public static final byte NULL = 0;
    public static final byte CLASS_DEF = 2;
    public static final byte ARRAY = 3;
    public static final byte PRIMITIVE_ARRAY = 4;
    public static final int CLASS = 5;
    private final Class clz;
    private final List fields;
    private final short classId;
    private final Constructor cons;
    private final Method writeReplaceMethod;
    private final Method readResolveMethod;
    private final List writeObjectMethods;
    private final List readObjectMethods;
    private final PrimitiveArray primitiveArray;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$io$Serializable;

    static ClassStreamHandler lookup(Class cls) throws NotSerializableException {
        ClassStreamHandler classHandler = (ClassStreamHandler)handlesClasses.get(cls.getName());
        if (classHandler == null) {
            classHandler = new ClassStreamHandler(cls);
            handlesClasses.put(cls.getName(), classHandler);
            handlesClasses.put(new Short(classHandler.getClassId()), classHandler);
        }
        return classHandler;
    }

    static ClassStreamHandler lookup(short s) {
        ClassStreamHandler classHandler = (ClassStreamHandler)handlesClasses.get(new Short(s));
        if (classHandler == null) {
            throw new RuntimeException("class not found for: " + s);
        }
        return classHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClassStreamHandler(Class cls) throws WicketSerializeableException {
        short s = classCounter;
        classCounter = (short)(s + 1);
        this.classId = s;
        this.clz = cls;
        if (cls.isPrimitive()) {
            this.fields = null;
            this.cons = null;
            this.writeObjectMethods = null;
            this.readObjectMethods = null;
            this.writeReplaceMethod = null;
            this.readResolveMethod = null;
            if (this.clz == Boolean.TYPE) {
                this.primitiveArray = new BooleanPrimitiveArray();
                return;
            } else if (this.clz == Byte.TYPE) {
                this.primitiveArray = new BytePrimitiveArray();
                return;
            } else if (this.clz == Short.TYPE) {
                this.primitiveArray = new ShortPrimitiveArray();
                return;
            } else if (this.clz == Character.TYPE) {
                this.primitiveArray = new CharPrimitiveArray();
                return;
            } else if (this.clz == Integer.TYPE) {
                this.primitiveArray = new IntPrimitiveArray();
                return;
            } else if (this.clz == Long.TYPE) {
                this.primitiveArray = new LongPrimitiveArray();
                return;
            } else if (this.clz == Float.TYPE) {
                this.primitiveArray = new FloatPrimitiveArray();
                return;
            } else {
                if (this.clz != Double.TYPE) throw new RuntimeException("Unsupported primitive " + cls);
                this.primitiveArray = new DoublePrimitiveArray();
            }
            return;
        } else if (cls.isInterface()) {
            this.fields = null;
            this.cons = null;
            this.writeObjectMethods = null;
            this.readObjectMethods = null;
            this.writeReplaceMethod = null;
            this.readResolveMethod = null;
            this.primitiveArray = null;
            return;
        } else if (Proxy.isProxyClass(this.clz)) {
            this.fields = null;
            this.cons = null;
            this.writeObjectMethods = null;
            this.writeReplaceMethod = null;
            this.readResolveMethod = null;
            this.readObjectMethods = null;
            this.primitiveArray = null;
            return;
        } else {
            this.fields = new ArrayList();
            this.primitiveArray = null;
            this.writeObjectMethods = new ArrayList(2);
            this.readObjectMethods = new ArrayList(2);
            this.writeReplaceMethod = ClassStreamHandler.getInheritableMethod(this.clz, "writeReplace", null, Object.class);
            this.readResolveMethod = ClassStreamHandler.getInheritableMethod(this.clz, "readResolve", null, Object.class);
            if (this.readResolveMethod == null) {
                this.cons = ClassStreamHandler.getSerializableConstructor(this.clz);
                if (this.cons == null) {
                    throw new WicketSerializeableException("No Serializable constructor found for " + cls);
                }
            } else {
                this.cons = ClassStreamHandler.getSerializableConstructor(this.clz);
            }
            for (Class parent = cls; parent != (class$java$lang$Object == null ? ClassStreamHandler.class$("java.lang.Object") : class$java$lang$Object); parent = parent.getSuperclass()) {
                Method method = ClassStreamHandler.getPrivateMethod(parent, "writeObject", new Class[]{class$java$io$ObjectOutputStream == null ? ClassStreamHandler.class$("java.io.ObjectOutputStream") : class$java$io$ObjectOutputStream}, Void.TYPE);
                if (method != null) {
                    this.writeObjectMethods.add(method);
                }
                if ((method = ClassStreamHandler.getPrivateMethod(parent, "readObject", new Class[]{class$java$io$ObjectInputStream == null ? ClassStreamHandler.class$("java.io.ObjectInputStream") : class$java$io$ObjectInputStream}, Void.TYPE)) == null) continue;
                this.readObjectMethods.add(method);
            }
            this.fillFields(cls);
        }
    }

    public Class getStreamClass() {
        return this.clz;
    }

    public short getClassId() {
        return this.classId;
    }

    public Object createObject() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.cons.newInstance(null);
    }

    private void fillFields(Class cls) {
        if (cls == null) {
            return;
        }
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            FieldAndIndex fai = null;
            Class<?> clz = field.getType();
            long offset = unsafe.objectFieldOffset(field);
            fai = clz == Boolean.TYPE ? new BooleanFieldAndIndex(field) : (clz == Byte.TYPE ? new ByteFieldAndIndex(field) : (clz == Short.TYPE ? new ShortFieldAndIndex(field) : (clz == Character.TYPE ? new CharFieldAndIndex(field) : (clz == Integer.TYPE ? new IntFieldAndIndex(field) : (clz == Long.TYPE ? new LongFieldAndIndex(field) : (clz == Float.TYPE ? new FloatFieldAndIndex(field) : (clz == Double.TYPE ? new DoubleFieldAndIndex(field) : new ObjectFieldAndIndex(field))))))));
            this.fields.add(fai);
        }
        if ((cls = cls.getSuperclass()) != Object.class) {
            this.fillFields(cls);
        }
    }

    public void writeFields(WicketObjectOutputStream woos, Object obj) throws WicketSerializeableException {
        FieldAndIndex fai = null;
        try {
            for (int i = 0; this.fields != null && i < this.fields.size(); ++i) {
                fai = (FieldAndIndex)this.fields.get(i);
                fai.writeField(obj, woos);
            }
        }
        catch (WicketSerializeableException wse) {
            wse.addTrace(fai.field.getName());
            throw wse;
        }
        catch (Exception ex) {
            String field = fai == null || fai.field == null ? "" : fai.field.getName();
            String msg = "Error writing field: " + field + " for object class: " + obj.getClass();
            throw new WicketSerializeableException(msg, ex);
        }
    }

    public void readFields(WicketObjectInputStream wois, Object object) throws WicketSerializeableException {
        FieldAndIndex fai = null;
        try {
            for (int i = 0; i < this.fields.size(); ++i) {
                fai = (FieldAndIndex)this.fields.get(i);
                fai.readField(object, wois);
            }
        }
        catch (WicketSerializeableException wse) {
            wse.addTrace(fai.field.getName());
            throw wse;
        }
        catch (Exception ex) {
            throw new WicketSerializeableException("Error reading field: " + fai.field.getName() + " for object class: " + object.getClass(), ex);
        }
    }

    public void writeArray(Object obj, WicketObjectOutputStream wois) throws IOException {
        this.primitiveArray.writeArray(obj, wois);
    }

    public Object readArray(WicketObjectInputStream wois) throws IOException {
        return this.primitiveArray.readArray(wois);
    }

    public boolean invokeWriteMethod(WicketObjectOutputStream woos, Object obj) {
        if (this.writeObjectMethods != null && this.writeObjectMethods.size() > 0) {
            int i = this.writeObjectMethods.size();
            while (--i >= 0) {
                Method method = (Method)this.writeObjectMethods.get(i);
                try {
                    method.invoke(obj, woos);
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return true;
        }
        return false;
    }

    public boolean invokeReadMethod(WicketObjectInputStream wois, Object obj) {
        if (this.readObjectMethods != null && this.readObjectMethods.size() > 0) {
            int i = this.readObjectMethods.size();
            while (--i >= 0) {
                Method method = (Method)this.readObjectMethods.get(i);
                try {
                    method.invoke(obj, wois);
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return true;
        }
        return false;
    }

    private static Constructor getSerializableConstructor(Class cl) {
        Class initCl = cl;
        while ((class$java$io$Serializable == null ? ClassStreamHandler.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(initCl)) {
            if ((initCl = initCl.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor<Object> cons = initCl.getDeclaredConstructor(null);
            int mods = cons.getModifiers();
            if ((mods & 2) != 0 || (mods & 5) == 0 && !ClassStreamHandler.packageEquals(cl, initCl)) {
                return null;
            }
            cons = reflFactory.newConstructorForSerialization(cl, cons);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Method getPrivateMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        try {
            Method meth = cl.getDeclaredMethod(name, argTypes);
            meth.setAccessible(true);
            int mods = meth.getModifiers();
            return meth.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0 ? meth : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Method getInheritableMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        Class defCl;
        Method meth = null;
        for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                meth = defCl.getDeclaredMethod(name, argTypes);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (meth == null || meth.getReturnType() != returnType) {
            return null;
        }
        meth.setAccessible(true);
        int mods = meth.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            return meth;
        }
        if ((mods & 2) != 0) {
            return cl == defCl ? meth : null;
        }
        return ClassStreamHandler.packageEquals(cl, defCl) ? meth : null;
    }

    private static boolean packageEquals(Class cl1, Class cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && ClassStreamHandler.getPackageName(cl1).equals(ClassStreamHandler.getPackageName(cl2));
    }

    private static String getPackageName(Class cl) {
        String s = cl.getName();
        int i = s.lastIndexOf(91);
        if (i >= 0) {
            s = s.substring(i + 2);
        }
        return (i = s.lastIndexOf(46)) >= 0 ? s.substring(0, i) : "";
    }

    public Object writeReplace(Object o) throws NotSerializableException {
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(o, null);
            }
            catch (Exception ex) {
                throw new NotSerializableException(ex.getMessage());
            }
        }
        return null;
    }

    public Object readResolve(Object o) throws NotSerializableException {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(o, null);
            }
            catch (Exception ex) {
                throw new NotSerializableException(ex.getMessage());
            }
        }
        return o;
    }

    static {
        try {
            Class<?>[] classes = ObjectStreamClass.class.getDeclaredClasses();
            for (int i = 0; i < classes.length; ++i) {
                if (!classes[i].getName().equals("java.io.ObjectStreamClass$FieldReflector")) continue;
                Field unsafeField = classes[i].getDeclaredField("unsafe");
                unsafeField.setAccessible(true);
                unsafe = (Unsafe)unsafeField.get(null);
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        reflFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        handlesClasses = new HashMap();
        classCounter = 0;
    }

    private final class DoublePrimitiveArray
    extends PrimitiveArray {
        private DoublePrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeDouble(Array.getDouble(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setDouble(array, i, dos.readDouble());
            }
            return array;
        }
    }

    private final class FloatPrimitiveArray
    extends PrimitiveArray {
        private FloatPrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeFloat(Array.getFloat(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setFloat(array, i, dos.readFloat());
            }
            return array;
        }
    }

    private final class LongPrimitiveArray
    extends PrimitiveArray {
        private LongPrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeLong(Array.getLong(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setLong(array, i, dos.readLong());
            }
            return array;
        }
    }

    private final class IntPrimitiveArray
    extends PrimitiveArray {
        private IntPrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeInt(Array.getInt(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setInt(array, i, dos.readInt());
            }
            return array;
        }
    }

    private final class CharPrimitiveArray
    extends PrimitiveArray {
        private CharPrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeChar(Array.getChar(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setChar(array, i, dos.readChar());
            }
            return array;
        }
    }

    private final class ShortPrimitiveArray
    extends PrimitiveArray {
        private ShortPrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeShort(Array.getShort(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setShort(array, i, dos.readShort());
            }
            return array;
        }
    }

    private final class BytePrimitiveArray
    extends PrimitiveArray {
        private BytePrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeByte(Array.getByte(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setByte(array, i, dos.readByte());
            }
            return array;
        }
    }

    private final class BooleanPrimitiveArray
    extends PrimitiveArray {
        private BooleanPrimitiveArray() {
        }

        public void writeArray(Object object, WicketObjectOutputStream dos) throws IOException {
            int length = Array.getLength(object);
            dos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                dos.writeBoolean(Array.getBoolean(object, i));
            }
        }

        public Object readArray(WicketObjectInputStream dos) throws IOException {
            int length = dos.readInt();
            Object array = Array.newInstance(ClassStreamHandler.this.getStreamClass(), length);
            for (int i = 0; i < length; ++i) {
                Array.setBoolean(array, i, dos.readBoolean());
            }
            return array;
        }
    }

    private abstract class PrimitiveArray {
        private PrimitiveArray() {
        }

        public abstract void writeArray(Object var1, WicketObjectOutputStream var2) throws IOException;

        public abstract Object readArray(WicketObjectInputStream var1) throws IOException;
    }

    private final class ObjectFieldAndIndex
    extends FieldAndIndex {
        ObjectFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeObject(unsafe.getObject(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException, ClassNotFoundException {
            unsafe.putObject(object, this.index, dos.readObject());
        }
    }

    private final class DoubleFieldAndIndex
    extends FieldAndIndex {
        DoubleFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeDouble(unsafe.getDouble(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putDouble(object, this.index, dos.readDouble());
        }
    }

    private final class FloatFieldAndIndex
    extends FieldAndIndex {
        FloatFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeFloat(unsafe.getFloat(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putFloat(object, this.index, dos.readFloat());
        }
    }

    private final class LongFieldAndIndex
    extends FieldAndIndex {
        LongFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeLong(unsafe.getLong(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putLong(object, this.index, dos.readLong());
        }
    }

    private final class IntFieldAndIndex
    extends FieldAndIndex {
        IntFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeInt(unsafe.getInt(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putInt(object, this.index, dos.readInt());
        }
    }

    private final class CharFieldAndIndex
    extends FieldAndIndex {
        CharFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeChar(unsafe.getChar(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putChar(object, this.index, dos.readChar());
        }
    }

    private final class ShortFieldAndIndex
    extends FieldAndIndex {
        ShortFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeShort(unsafe.getShort(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putShort(object, this.index, dos.readShort());
        }
    }

    private final class ByteFieldAndIndex
    extends FieldAndIndex {
        ByteFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeByte(unsafe.getByte(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putByte(object, this.index, dos.readByte());
        }
    }

    private final class BooleanFieldAndIndex
    extends FieldAndIndex {
        BooleanFieldAndIndex(Field field) {
            super(field);
        }

        public void writeField(Object object, WicketObjectOutputStream dos) throws IOException {
            dos.writeBoolean(unsafe.getBoolean(object, this.index));
        }

        public void readField(Object object, WicketObjectInputStream dos) throws IOException {
            unsafe.putBoolean(object, this.index, dos.readBoolean());
        }
    }

    private abstract class FieldAndIndex {
        final Field field;
        final long index;

        FieldAndIndex(Field field) {
            this.field = field;
            this.index = unsafe.objectFieldOffset(field);
        }

        public abstract void writeField(Object var1, WicketObjectOutputStream var2) throws IOException;

        public abstract void readField(Object var1, WicketObjectInputStream var2) throws IOException, ClassNotFoundException;
    }
}

