/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.Locale;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class DefaultMarkupCacheKeyProvider
implements IMarkupCacheKeyProvider {
    public String getCacheKey(MarkupContainer container, Class clazz) {
        String classname = clazz.getName();
        Locale locale = container.getLocale();
        String style = container.getStyle();
        String markupType = container.getMarkupType();
        AppendingStringBuffer buffer = new AppendingStringBuffer(classname.length() + 64);
        buffer.append(classname);
        if (locale != null) {
            boolean l = locale.getLanguage().length() != 0;
            boolean c = locale.getCountry().length() != 0;
            boolean v = locale.getVariant().length() != 0;
            buffer.append(locale.getLanguage());
            if (c || l && v) {
                buffer.append('_').append(locale.getCountry());
            }
            if (v && (l || c)) {
                buffer.append('_').append(locale.getVariant());
            }
        }
        if (style != null) {
            buffer.append(style);
        }
        buffer.append(markupType);
        return buffer.toString();
    }
}

