/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.grid;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.DataViewBase;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.util.ArrayIteratorAdapter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class AbstractDataGridView
extends DataViewBase {
    private static final long serialVersionUID = 1L;
    private static final String CELL_REPEATER_ID = "cells";
    private static final String CELL_ITEM_ID = "cell";
    private ICellPopulator[] populators;
    private transient ArrayIteratorAdapter populatorsIteratorCache;

    public AbstractDataGridView(String id, ICellPopulator[] populators, IDataProvider dataProvider) {
        super(id, dataProvider);
        this.populators = populators;
    }

    private Iterator getPopulatorsIterator() {
        if (this.populatorsIteratorCache == null) {
            this.populatorsIteratorCache = new ArrayIteratorAdapter(this.internalGetPopulators()){

                protected IModel model(Object object) {
                    return new Model((Serializable)object);
                }
            };
        } else {
            this.populatorsIteratorCache.reset();
        }
        return this.populatorsIteratorCache;
    }

    protected final ICellPopulator[] internalGetPopulators() {
        return this.populators;
    }

    protected Item newCellItem(String id, int index, IModel model) {
        return new Item(id, index, model);
    }

    protected final Item newItem(String id, int index, IModel model) {
        return this.newRowItem(id, index, model);
    }

    protected Item newRowItem(String id, int index, IModel model) {
        return new Item(id, index, model);
    }

    protected void onDetach() {
        super.onDetach();
        if (this.populators != null) {
            for (int i = 0; i < this.populators.length; ++i) {
                this.populators[i].detach();
            }
        }
    }

    protected final void populateItem(Item item) {
        RepeatingView cells = new RepeatingView(CELL_REPEATER_ID);
        item.add((Component)cells);
        Iterator populators = this.getPopulatorsIterator();
        int i = 0;
        while (populators.hasNext()) {
            IModel populatorModel = (IModel)populators.next();
            Item cellItem = this.newCellItem(cells.newChildId(), i, populatorModel);
            cells.add((Component)cellItem);
            ICellPopulator populator = (ICellPopulator)cellItem.getModelObject();
            populator.populateItem(cellItem, CELL_ITEM_ID, item.getModel());
            if (cellItem.get(CELL_ITEM_ID) == null) {
                throw new WicketRuntimeException(populator.getClass().getName() + ".populateItem() failed to add a component with id [" + CELL_ITEM_ID + "] to the provided [cellItem] object. Make sure you call add() on cellItem ( cellItem.add(new MyComponent(componentId, rowModel) )");
            }
            ++i;
        }
    }
}

