/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class TypeManager {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final ClassLoaderResolver clr;
    Map<String, JavaType> javaTypes = new HashMap<String, JavaType>();
    Map<Class, ObjectStringConverter> stringConvertersByType = null;
    private static String[] DEFAULT_PERSISTENT_TYPE;
    private static String[] DEFAULT_FETCH_GROUP_TRUE;
    private static String[] DEFAULT_EMBEDDED_TYPE;

    public TypeManager(ApiAdapter api, PluginManager mgr, ClassLoaderResolver clr) {
        this.clr = clr;
        this.loadJavaTypes(mgr, clr);
    }

    public Set getSupportedSecondClassTypes() {
        return new HashSet<String>(this.javaTypes.keySet());
    }

    public boolean isSupportedSecondClassType(String className) {
        if (className == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(className);
        if (type == null) {
            try {
                Class cls = this.clr.classForName(className);
                type = this.findJavaTypeForClass(cls);
                return type != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String[] filterOutSupportedSecondClassNames(String[] inputClassNames) {
        int filteredClasses = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (!this.isSupportedSecondClassType(inputClassNames[i])) continue;
            inputClassNames[i] = null;
            ++filteredClasses;
        }
        if (filteredClasses == 0) {
            return inputClassNames;
        }
        String[] restClasses = new String[inputClassNames.length - filteredClasses];
        int m = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (inputClassNames[i] == null) continue;
            restClasses[m++] = inputClassNames[i];
        }
        return restClasses;
    }

    public boolean isDefaultPersistent(Class c) {
        if (c == null) {
            return false;
        }
        if (Arrays.binarySearch(DEFAULT_PERSISTENT_TYPE, c.getName()) >= 0) {
            return true;
        }
        JavaType type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.persistent;
        }
        return false;
    }

    public boolean isDefaultFetchGroup(Class c) {
        if (c == null) {
            return false;
        }
        if (Arrays.binarySearch(DEFAULT_FETCH_GROUP_TRUE, c.getName()) >= 0) {
            return true;
        }
        JavaType type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    public boolean isDefaultEmbeddedType(Class c) {
        if (c == null) {
            return false;
        }
        if (Arrays.binarySearch(DEFAULT_EMBEDDED_TYPE, c.getName()) >= 0) {
            return true;
        }
        JavaType type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.embedded;
        }
        return false;
    }

    public boolean isSecondClassMutableType(String className) {
        return this.getWrapperTypeForType(className) != null;
    }

    public Class getWrapperTypeForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperType;
    }

    public Class getWrappedTypeBackedForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperTypeBacked;
    }

    public boolean isSecondClassWrapper(String className) {
        if (className == null) {
            return false;
        }
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return true;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public Class getTypeForSecondClassWrapper(String className) {
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return type.cls;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return type.cls;
        }
        return null;
    }

    public ObjectStringConverter getStringConverter(Class type) {
        ObjectStringConverter converter = null;
        if (this.stringConvertersByType != null && (converter = this.stringConvertersByType.get(type)) != null) {
            return converter;
        }
        JavaType javaType = this.findJavaTypeForClass(type);
        if (javaType.stringConverter != null) {
            try {
                converter = (ObjectStringConverter)javaType.stringConverter.newInstance();
            }
            catch (Exception e) {
                throw new NucleusUserException("Error instantiating string converter for type=" + type.getName(), e);
            }
        }
        if (converter != null) {
            if (this.stringConvertersByType == null) {
                this.stringConvertersByType = new Hashtable<Class, ObjectStringConverter>();
            }
            this.stringConvertersByType.put(type, converter);
        }
        return converter;
    }

    protected JavaType findJavaTypeForClass(Class cls) {
        if (cls == null) {
            return null;
        }
        JavaType type2 = this.javaTypes.get(cls.getName());
        if (type2 != null) {
            return type2;
        }
        Class<?> componentCls = cls.isArray() ? cls.getComponentType() : null;
        HashSet<JavaType> supportedTypes = new HashSet<JavaType>(this.javaTypes.values());
        for (JavaType type2 : supportedTypes) {
            if (type2.cls == cls) {
                return type2;
            }
            if (type2.cls.getName().equals("java.lang.Object") || type2.cls.getName().equals("java.io.Serializable")) continue;
            if (componentCls != null) {
                if (!type2.cls.isArray() || !type2.cls.getComponentType().isAssignableFrom(componentCls)) continue;
                this.javaTypes.put(cls.getName(), type2);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
                }
                return type2;
            }
            if (!type2.cls.isAssignableFrom(cls)) continue;
            this.javaTypes.put(cls.getName(), type2);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
            }
            return type2;
        }
        return null;
    }

    private void loadJavaTypes(PluginManager mgr, ClassLoaderResolver clr) {
        ExtensionPoint exPoint = mgr.getExtensionPoint("org.datanucleus.java_type");
        for (int i = 0; i < exPoint.getExtensions().length; ++i) {
            ConfigurationElement[] elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (int elemNo = 0; elemNo < elms.length; ++elemNo) {
                String javaName = elms[elemNo].getAttribute("name").trim();
                String persistentString = elms[elemNo].getAttribute("persistent");
                String embeddedString = elms[elemNo].getAttribute("embedded");
                String dfgString = elms[elemNo].getAttribute("dfg");
                String javaVersionRestrict = elms[elemNo].getAttribute("java-version-restricted");
                String javaVersion = elms[elemNo].getAttribute("java-version");
                String wrapperType = elms[elemNo].getAttribute("wrapper-type");
                String wrapperTypeBacked = elms[elemNo].getAttribute("wrapper-type-backed");
                String stringConverterName = elms[elemNo].getAttribute("string-converter");
                boolean persistent = false;
                if (persistentString != null && persistentString.equalsIgnoreCase("true")) {
                    persistent = true;
                }
                boolean embedded = false;
                if (embeddedString != null && embeddedString.equalsIgnoreCase("true")) {
                    embedded = true;
                }
                boolean dfg = false;
                if (dfgString != null && dfgString.equalsIgnoreCase("true")) {
                    dfg = true;
                }
                boolean versionRestricted = false;
                if (javaVersionRestrict != null && javaVersionRestrict.equalsIgnoreCase("true")) {
                    versionRestricted = true;
                }
                wrapperType = !StringUtils.isWhitespace(wrapperType) ? wrapperType.trim() : null;
                wrapperTypeBacked = !StringUtils.isWhitespace(wrapperTypeBacked) ? wrapperTypeBacked.trim() : null;
                stringConverterName = !StringUtils.isWhitespace(stringConverterName) ? stringConverterName.trim() : null;
                if (StringUtils.isWhitespace(javaVersion)) {
                    javaVersion = "1.3";
                }
                if ((!JavaUtils.isGreaterEqualsThan(javaVersion) || versionRestricted) && (!JavaUtils.isEqualsThan(javaVersion) || !versionRestricted)) continue;
                try {
                    Class cls = clr.classForName(javaName);
                    Class wrapperClass = null;
                    if (wrapperType != null) {
                        try {
                            wrapperClass = mgr.loadClass(elms[elemNo].getExtension().getPlugin().getSymbolicName(), wrapperType);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)wrapperType));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)wrapperType));
                        }
                    }
                    Class wrapperClassBacked = null;
                    if (wrapperTypeBacked != null) {
                        try {
                            wrapperClassBacked = mgr.loadClass(elms[elemNo].getExtension().getPlugin().getSymbolicName(), wrapperTypeBacked);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)wrapperTypeBacked));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)wrapperTypeBacked));
                        }
                    }
                    Class stringConverterClass = null;
                    if (stringConverterName != null) {
                        try {
                            stringConverterClass = mgr.loadClass(elms[elemNo].getExtension().getPlugin().getSymbolicName(), stringConverterName);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)stringConverterName));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)stringConverterName));
                        }
                    }
                    JavaType type = new JavaType(cls, persistent, embedded, dfg, wrapperClass, wrapperClassBacked, stringConverterClass);
                    this.addJavaType(type, javaVersion, versionRestricted);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    protected void addJavaType(JavaType type, String javaVersion, boolean versionRestricted) {
        String typeName = type.cls.getName();
        this.javaTypes.put(typeName, type);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016000", (Object)typeName, (Object)("" + type.persistent), (Object)("" + type.dfg), (Object)("" + type.embedded)));
        }
        if (type.persistent) {
            this.addDefaultPersistent(typeName);
        }
        if (type.embedded) {
            this.addDefaultEmbedded(typeName);
        }
        if (type.dfg) {
            this.addDefaultFetchGroup(typeName);
        }
    }

    private synchronized void addDefaultPersistent(String className) {
        if (DEFAULT_PERSISTENT_TYPE == null) {
            DEFAULT_PERSISTENT_TYPE = new String[1];
            TypeManager.DEFAULT_PERSISTENT_TYPE[0] = className;
        } else {
            Object[] temp = new String[DEFAULT_PERSISTENT_TYPE.length + 1];
            System.arraycopy(DEFAULT_PERSISTENT_TYPE, 0, temp, 0, DEFAULT_PERSISTENT_TYPE.length);
            temp[temp.length - 1] = className;
            Arrays.sort(temp);
            DEFAULT_PERSISTENT_TYPE = temp;
        }
    }

    private synchronized void addDefaultFetchGroup(String className) {
        if (DEFAULT_FETCH_GROUP_TRUE == null) {
            DEFAULT_FETCH_GROUP_TRUE = new String[1];
            TypeManager.DEFAULT_FETCH_GROUP_TRUE[0] = className;
        } else {
            Object[] temp = new String[DEFAULT_FETCH_GROUP_TRUE.length + 1];
            System.arraycopy(DEFAULT_FETCH_GROUP_TRUE, 0, temp, 0, DEFAULT_FETCH_GROUP_TRUE.length);
            temp[temp.length - 1] = className;
            Arrays.sort(temp);
            DEFAULT_FETCH_GROUP_TRUE = temp;
        }
    }

    private synchronized void addDefaultEmbedded(String className) {
        if (DEFAULT_EMBEDDED_TYPE == null) {
            DEFAULT_EMBEDDED_TYPE = new String[1];
            TypeManager.DEFAULT_EMBEDDED_TYPE[0] = className;
        } else {
            Object[] temp = new String[DEFAULT_EMBEDDED_TYPE.length + 1];
            System.arraycopy(DEFAULT_EMBEDDED_TYPE, 0, temp, 0, DEFAULT_EMBEDDED_TYPE.length);
            temp[temp.length - 1] = className;
            Arrays.sort(temp);
            DEFAULT_EMBEDDED_TYPE = temp;
        }
    }

    class JavaType {
        final Class cls;
        final boolean persistent;
        final boolean embedded;
        final boolean dfg;
        final Class wrapperType;
        final Class wrapperTypeBacked;
        final Class stringConverter;

        public JavaType(Class cls, boolean persistent, boolean embedded, boolean dfg, Class wrapperType, Class wrapperTypeBacked, Class stringConverter) {
            this.cls = cls;
            this.persistent = persistent;
            this.embedded = embedded;
            this.dfg = dfg;
            this.wrapperType = wrapperType;
            this.wrapperTypeBacked = wrapperTypeBacked != null ? wrapperTypeBacked : wrapperType;
            this.stringConverter = stringConverter;
        }
    }
}

