/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractSetStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.ClassUtils;

public abstract class MapValueSetStore
extends AbstractSetStore {
    protected final MapStore mapStore;
    protected final JavaTypeMapping keyMapping;
    private DatastoreIdentifier valueIdentifier;

    public MapValueSetStore(DatastoreContainerObject mapTable, MapStore mapStore, ClassLoaderResolver clr, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)mapTable.getStoreManager(), clr, specialization);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.setName = "values";
        this.ownerMapping = ownerMapping;
        this.keyMapping = keyMapping;
        this.elementMapping = valueMapping;
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        this.initialize(clr);
        this.postInit();
    }

    public MapValueSetStore(DatastoreClass valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractMemberMetaData fmd, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)valueTable.getStoreManager(), clr, specialization);
        this.containerTable = valueTable;
        this.setName = "values";
        this.ownerMemberMetaData = fmd;
        this.ownerMapping = ownerMapping;
        this.keyMapping = null;
        this.elementMapping = valueMapping;
        this.mapStore = mapStore;
        this.initialize(clr);
        this.postInit();
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        Class element_class = clr.classForName(this.elementType);
        this.emd = ClassUtils.isReferenceType(element_class) ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
        this.valueIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "VALUE");
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        Class elementCls = clr.classForName(this.elementType);
        QueryExpression stmt = null;
        if (this.emd != null && this.emd.getDiscriminatorStrategy() != null && this.emd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && this.containerTable instanceof DatastoreClass) {
            if (ClassUtils.isReferenceType(clr.classForName(this.elementType))) {
                String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int j = 0; j < clsNames.length; ++j) {
                    cls[j] = clr.classForName(clsNames[j]);
                }
                stmt = this.getSpecialization().newDiscriminatorIteratorStatement(clr, cls, true, true).getQueryStatement(null);
            } else {
                stmt = this.getSpecialization().newDiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, true).getQueryStatement(null);
            }
            this.iterateUsingDiscriminator = true;
            DatastoreClass sourceTable = this.storeMgr.getDatastoreClass(this.elementType, clr);
            if (this.containerTable != sourceTable) {
                ScalarExpression sourceExpr = sourceTable.getIDMapping().newScalarExpression(stmt, stmt.getMainTableExpression());
                LogicSetExpression teTargetElement = stmt.newTableExpression(this.containerTable, this.valueIdentifier);
                ScalarExpression targetExpr = this.elementMapping.newScalarExpression(stmt, teTargetElement);
                stmt.innerJoin(sourceExpr, targetExpr, teTargetElement, true);
            }
        } else {
            stmt = this.getSpecialization().newUnionIteratorStatement(clr, elementCls, true, elementCls, this.elementMapping, this.containerTable, false, null, true, false).getQueryStatement(null);
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        return stmt;
    }

    public boolean add(StateManager sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        return this.remove(sm, element);
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        throw new NucleusUserException("Cannot remove elements from a map through its value set");
    }

    public void clear(StateManager sm) {
        if (this.canClear()) {
            throw new NucleusUserException("Cannot clear an inverse map through its value set");
        }
        super.clear(sm);
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar, boolean existsQuery) {
        throw new NucleusUserException("Cannot query sets obtained by Map.values()");
    }

    private AbstractSetStoreSpecialization getSpecialization() {
        return (AbstractSetStoreSpecialization)this.specialization;
    }

    protected abstract void postInit();

    protected abstract boolean canClear();

    protected abstract boolean remove(StateManager var1, Object var2);
}

