/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml.registrator.bean.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Named;
import javax.annotation.Stereotype;
import javax.context.ScopeType;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import org.dom4j.Element;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.xml.ParseXmlHelper;
import org.jboss.webbeans.xml.XmlEnvironment;
import org.jboss.webbeans.xml.checker.beanchildren.BeanChildrenChecker;
import org.jboss.webbeans.xml.registrator.bean.BeanElementRegistrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanElementRegistratorImpl
implements BeanElementRegistrator {
    protected final BeanChildrenChecker childrenChecker;
    protected final XmlEnvironment environment;
    protected final Map<String, Set<String>> packagesMap;

    protected BeanElementRegistratorImpl(BeanChildrenChecker childrenChecker) {
        this.childrenChecker = childrenChecker;
        this.environment = childrenChecker.getXmlEnvironment();
        this.packagesMap = childrenChecker.getPackagesMap();
    }

    @Override
    public abstract boolean accept(Element var1, AnnotatedClass<?> var2);

    protected abstract void checkElementDeclaration(Element var1, AnnotatedClass<?> var2);

    @Override
    public void registerBeanElement(Element beanElement, AnnotatedClass<?> beanClass) {
        this.checkElementDeclaration(beanElement, beanClass);
        this.childrenChecker.checkChildren(beanElement, beanClass);
        this.checkProduces(beanElement, beanClass);
        this.register(beanElement, beanClass);
    }

    protected void register(Element beanElement, AnnotatedClass<?> beanClass) {
        this.environment.getClasses().add(beanClass);
    }

    private void checkProduces(Element beanElement, AnnotatedClass<?> beanClass) {
        Iterator beanIterator = beanElement.elementIterator();
        while (beanIterator.hasNext()) {
            Element beanChild = (Element)beanIterator.next();
            List<Element> producesElements = ParseXmlHelper.findElementsInEeNamespace(beanChild, "Produces");
            if (producesElements.size() == 0) continue;
            if (producesElements.size() > 1) {
                throw new DefinitionException("There is more than one child <Produces> element for <" + beanChild.getName() + "> element");
            }
            ArrayList<AnnotatedClass<Object>> producesChildTypes = new ArrayList<AnnotatedClass<Object>>();
            Element producesElement = producesElements.get(0);
            Iterator producesIt = producesElement.elementIterator();
            while (producesIt.hasNext()) {
                boolean isInterface;
                Element producesChild = (Element)producesIt.next();
                AnnotatedClass<Object> producesChildClass = ParseXmlHelper.loadElementClass(producesChild, Object.class, this.environment, this.packagesMap);
                Class producesChildType = producesChildClass.getRawType();
                boolean isJavaClass = !producesChildType.isEnum() && !producesChildType.isPrimitive() && !producesChildType.isInterface();
                boolean bl = isInterface = producesChildType.isInterface() && !producesChildType.isAnnotation();
                if (isJavaClass || isInterface) {
                    producesChildTypes.add(producesChildClass);
                    continue;
                }
                if (producesChildType.isAnnotation()) {
                    if (producesChildClass.isAnnotationPresent(DeploymentType.class) || producesChildClass.isAnnotationPresent(ScopeType.class) || producesChildClass.isAnnotationPresent(Stereotype.class) || producesChildClass.isAnnotationPresent(Named.class)) continue;
                    throw new DefinitionException("<" + producesChild.getName() + "> direct child of <Produces> element for <" + beanChild.getName() + "> in bean" + beanElement.getName() + "must be DeploymentType or ScopeType or Stereotype or Named");
                }
                throw new DefinitionException("Only Java class, interface type and Java annotation type can be direct child of <Produces> element for <" + beanChild.getName() + "> in bean" + beanElement.getName() + ". Element <" + producesChild.getName() + "> is incorrect");
            }
            if (producesChildTypes.size() != 1) {
                throw new DefinitionException("More than one or no one child element of <Produces> element for <" + beanChild.getName() + "> in bean" + beanElement.getName() + " represents a Java class or interface type");
            }
            AnnotatedClass expectedType = (AnnotatedClass)producesChildTypes.get(0);
            Method beanMethod = null;
            AnnotatedField beanField = beanClass.getDeclaredField(beanChild.getName(), expectedType);
            try {
                ArrayList paramClassesList = new ArrayList();
                Iterator beanChildIt = beanChild.elementIterator();
                while (beanChildIt.hasNext()) {
                    Element methodChild = (Element)beanChildIt.next();
                    if (methodChild.getName().equalsIgnoreCase("Produces")) continue;
                    paramClassesList.add(ParseXmlHelper.loadElementClass(methodChild, Object.class, this.environment, this.packagesMap).getRawType());
                }
                Class[] paramClasses = paramClassesList.toArray(new Class[0]);
                beanMethod = beanClass.getRawType().getDeclaredMethod(beanChild.getName(), paramClasses);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (beanField != null && beanMethod != null) {
                throw new DefinitionException("Class '" + beanClass.getName() + "' has produser field and method with the same name '" + beanField.getName() + "'");
            }
            if (beanField != null) {
                if (beanChild.elements().size() <= 1) continue;
                throw new DefinitionException("There is more than one direct child element for producer field <" + beanChild.getName() + ">");
            }
            if (beanMethod != null) {
                Iterator beanChildIt = beanChild.elementIterator();
                while (beanChildIt.hasNext()) {
                    Element element = (Element)beanChildIt.next();
                    if (element.getName().equalsIgnoreCase("Produces") || ParseXmlHelper.findElementsInEeNamespace(beanChild, "Interceptor").size() != 0) continue;
                    throw new DefinitionException("Only Produces and interceptor binding types can be direct childs of a producer method '" + beanChild.getName() + "' declaration in bean '" + beanElement.getName() + "'");
                }
                continue;
            }
            throw new DefinitionException("A producer '" + beanChild.getName() + "' doesn't declared in '" + beanElement.getName() + "' class file as method or field");
        }
    }
}

