/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotatedAnnotation;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedType;
import org.jboss.webbeans.introspector.jlr.AnnotatedMethodImpl;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.collections.multi.SetHashMultiMap;
import org.jboss.webbeans.util.collections.multi.SetMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedAnnotationImpl<T extends Annotation>
extends AbstractAnnotatedType<T>
implements AnnotatedAnnotation<T> {
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedMethod<?>> annotatedMembers;
    private final Class<T> clazz;
    private final Set<AnnotatedMethod<?>> members;
    private final Map<String, AnnotatedMethod<?>> namedMembers;
    private String toString;

    public static <A extends Annotation> AnnotatedAnnotation<A> of(Class<A> annotationType, ClassTransformer classTransformer) {
        return new AnnotatedAnnotationImpl<A>(annotationType, classTransformer);
    }

    protected AnnotatedAnnotationImpl(Class<T> annotationType, ClassTransformer classTransformer) {
        super(AnnotationStore.of(annotationType), annotationType, annotationType, classTransformer);
        this.clazz = annotationType;
        this.members = new HashSet();
        this.annotatedMembers = new SetHashMultiMap();
        this.namedMembers = new HashMap();
        for (Method member : this.clazz.getDeclaredMethods()) {
            AnnotatedMethodImpl annotatedMethod = AnnotatedMethodImpl.of(member, this);
            this.members.add(annotatedMethod);
            for (Annotation annotation : annotatedMethod.getAnnotationsAsSet()) {
                this.annotatedMembers.put(annotation.annotationType(), annotatedMethod);
            }
            this.namedMembers.put(annotatedMethod.getName(), annotatedMethod);
        }
    }

    @Override
    public Set<AnnotatedMethod<?>> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public Set<AnnotatedMethod<?>> getAnnotatedMembers(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.annotatedMembers.get(annotationType));
    }

    @Override
    public <A> AnnotatedMethod<A> getMember(String memberName, AnnotatedClass<A> expectedType) {
        return this.namedMembers.get(memberName);
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        return this.toString;
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }

    public AnnotatedAnnotation<T> wrap(Set<Annotation> annotations) {
        throw new UnsupportedOperationException();
    }
}

