/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.string;

import org.apache.wicket.Response;
import org.apache.wicket.util.string.Strings;

public class JavascriptUtils {
    public static final String SCRIPT_OPEN_TAG = "<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n";
    public static final String SCRIPT_CLOSE_TAG = "\n/*-->]]>*/</script>\n";
    public static final String SCRIPT_CONTENT_PREFIX = "<!--/*--><![CDATA[/*><!--*/\n";
    public static final String SCRIPT_CONTENT_SUFFIX = "\n/*-->]]>*/";
    private final Response response;

    public JavascriptUtils(Response response, String id) {
        this.response = response;
        JavascriptUtils.writeOpenTag(response, id);
    }

    public JavascriptUtils(Response response) {
        this.response = response;
        JavascriptUtils.writeOpenTag(response);
    }

    public static CharSequence escapeQuotes(CharSequence input) {
        CharSequence s = input;
        if (s != null) {
            s = Strings.replaceAll(s, "'", "\\'");
        }
        return s;
    }

    public static void writeJavascriptUrl(Response response, CharSequence url, String id) {
        response.write("<script type=\"text/javascript\" ");
        if (id != null) {
            response.write("id=\"" + id + "\" ");
        }
        response.write("src=\"");
        response.write(url);
        response.println("\"></script>");
    }

    public static void writeJavascriptUrl(Response response, CharSequence url) {
        JavascriptUtils.writeJavascriptUrl(response, url, null);
    }

    public static void writeJavascript(Response response, CharSequence text, String id) {
        JavascriptUtils.writeOpenTag(response, id);
        response.write(text);
        JavascriptUtils.writeCloseTag(response);
    }

    public static void writeJavascript(Response response, CharSequence text) {
        JavascriptUtils.writeJavascript(response, text, null);
    }

    public static void writeOpenTag(Response response, String id) {
        response.write("<script type=\"text/javascript\" ");
        if (id != null) {
            response.write("id=\"" + id + "\"");
        }
        response.write(">");
        response.write(SCRIPT_CONTENT_PREFIX);
    }

    public static void writeOpenTag(Response response) {
        JavascriptUtils.writeOpenTag(response, null);
    }

    public static void writeCloseTag(Response response) {
        response.write(SCRIPT_CONTENT_SUFFIX);
        response.println("</script>\n");
    }

    public void write(CharSequence script) {
        this.response.write(script);
    }

    public void println(CharSequence script) {
        this.response.println(script);
    }

    public void close() {
        JavascriptUtils.writeCloseTag(this.response);
    }
}

