/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.string.StringValue;

public abstract class EnumeratedType
extends StringValue {
    private static final long serialVersionUID = 1L;
    private static final Map valueListByClass = new ConcurrentHashMap();

    public EnumeratedType(String name) {
        super(name);
        EnumeratedType.getValues(this.getClass()).add(this);
    }

    public static List getValues(Class c) {
        ArrayList valueList = (ArrayList)valueListByClass.get(c.getName());
        if (valueList == null) {
            valueList = new ArrayList();
            valueListByClass.put(c.getName(), valueList);
        }
        return valueList;
    }

    public Object readResolve() throws ObjectStreamException {
        EnumeratedType result = this;
        List values = EnumeratedType.getValues(this.getClass());
        if (values != null) {
            Iterator i = values.iterator();
            while (i.hasNext()) {
                EnumeratedType type = (EnumeratedType)i.next();
                if (type.toString() == null || !type.toString().equals(this.toString())) continue;
                result = type;
                break;
            }
        }
        return result;
    }
}

