/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import org.apache.wicket.AbortException;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.pages.BrowserInfoPage;
import org.apache.wicket.protocol.http.BufferedHttpServletResponse;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequestCycle
extends RequestCycle {
    private static final Logger log = LoggerFactory.getLogger((Class)WebRequestCycle.class);
    private static final MetaDataKey BROWSER_WAS_POLLED_KEY = new MetaDataKey(Boolean.class){
        private static final long serialVersionUID = 1L;
    };

    public WebRequestCycle(WebApplication application, WebRequest request, Response response) {
        super(application, request, response);
    }

    public IRequestCycleProcessor getProcessor() {
        return ((WebApplication)this.getApplication()).getRequestCycleProcessor();
    }

    public WebRequest getWebRequest() {
        return (WebRequest)this.request;
    }

    public WebResponse getWebResponse() {
        return (WebResponse)this.response;
    }

    public WebSession getWebSession() {
        return (WebSession)this.getSession();
    }

    /*
     * Unable to fully structure code
     */
    public final void redirectTo(Page page) {
        redirectUrl = null;
        settings = this.application.getRequestCycleSettings();
        if (settings.getRenderStrategy() == IRequestCycleSettings.REDIRECT_TO_BUFFER && this.application instanceof WebApplication && !this.getWebRequest().isAjax()) {
            currentResponse = this.getWebResponse();
            try {
                if (this.getWebRequest() instanceof ServletWebRequest) {
                    ((ServletWebRequest)this.getWebRequest()).setWicketRedirectUrl(Strings.replaceAll(page.urlFor(IRedirectListener.INTERFACE).toString(), "../", "").toString());
                }
                servletResponse = new BufferedHttpServletResponse(currentResponse.getHttpServletResponse());
                redirectResponse = new WebResponse(servletResponse){

                    public CharSequence encodeURL(CharSequence url) {
                        return currentResponse.encodeURL(url);
                    }
                };
                redirectResponse.setCharacterEncoding(currentResponse.getCharacterEncoding());
                this.setResponse(redirectResponse);
                page.renderPage();
                this.setResponse(currentResponse);
                responseRedirect = servletResponse.getRedirectUrl();
                if (responseRedirect != null) {
                    redirectUrl = responseRedirect;
                }
                if (servletResponse.getContentLength() <= 0) ** GOTO lbl43
                servletResponse.filter(currentResponse);
                servletResponse.setCharacterEncoding(currentResponse.getCharacterEncoding());
                servletResponse.close();
                if (this.getWebRequest() instanceof ServletWebRequest) {
                    ((ServletWebRequest)this.getWebRequest()).setWicketRedirectUrl(null);
                }
                redirectUrl = page.urlFor(IRedirectListener.INTERFACE).toString();
                stripped = Strings.replaceAll(redirectUrl, "../", "").toString();
                index = stripped.indexOf("?");
                sessionId = this.getApplication().getSessionStore().getSessionId(this.request, true);
                ((WebApplication)this.application).addBufferedResponse(sessionId, stripped.substring(index + 1), servletResponse);
            }
            catch (RuntimeException ex) {
                this.setResponse(currentResponse);
                if (ex instanceof AbortException) {
                    throw ex;
                }
                if (!(ex instanceof PageExpiredException)) {
                    this.logRuntimeException(ex);
                }
                processor = this.getProcessor();
                processor.respond(ex, this);
                return;
            }
        } else {
            redirectUrl = page.urlFor(IRedirectListener.INTERFACE).toString();
        }
lbl43:
        // 4 sources

        if (redirectUrl == null) {
            redirectUrl = page.urlFor(IRedirectListener.INTERFACE).toString();
        }
        this.getSession().touch(page);
        this.response.redirect(redirectUrl);
    }

    protected ClientInfo newClientInfo() {
        if (this.getApplication().getRequestCycleSettings().getGatherExtendedBrowserInfo()) {
            Session session = this.getSession();
            if (session.getMetaData(BROWSER_WAS_POLLED_KEY) == null) {
                session.setMetaData(BROWSER_WAS_POLLED_KEY, Boolean.TRUE);
                String url = "/" + this.getRequest().getURL();
                throw new RestartResponseException(new BrowserInfoPage(url));
            }
            session.setMetaData(BROWSER_WAS_POLLED_KEY, null);
        }
        return new WebClientInfo(this);
    }

    public final boolean isRedirect() {
        if (this.getWebRequest().isAjax()) {
            return true;
        }
        return super.isRedirect();
    }
}

