/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class ListMultipleChoice
extends AbstractChoice {
    private static final long serialVersionUID = 1L;
    private static int defaultMaxRows = 8;
    private int maxRows = defaultMaxRows;

    protected static int getDefaultMaxRows() {
        return defaultMaxRows;
    }

    protected static void setDefaultMaxRows(int defaultMaxRows) {
        ListMultipleChoice.defaultMaxRows = defaultMaxRows;
    }

    public ListMultipleChoice(String id) {
        super(id);
    }

    public ListMultipleChoice(String id, List choices) {
        super(id, choices);
    }

    public ListMultipleChoice(String id, List choices, int maxRows) {
        super(id, choices);
        this.maxRows = maxRows;
    }

    public ListMultipleChoice(String id, List choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel object, List choices) {
        super(id, object, choices);
    }

    public ListMultipleChoice(String id, IModel object, List choices, IChoiceRenderer renderer) {
        super(id, object, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel choices) {
        super(id, choices);
    }

    public ListMultipleChoice(String id, IModel model, IModel choices) {
        super(id, model, choices);
    }

    public ListMultipleChoice(String id, IModel choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel model, IModel choices, IChoiceRenderer renderer) {
        super(id, model, choices, renderer);
    }

    public final ListMultipleChoice setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public final String getModelValue() {
        Object modelObject = this.getModelObject();
        if (modelObject != null && !(modelObject instanceof Collection)) {
            throw new WicketRuntimeException("Model object for a ListMultipleChoice must be a Collection (found " + modelObject.getClass() + ")");
        }
        Collection selectedValues = (Collection)modelObject;
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        if (selectedValues != null) {
            List choices = this.getChoices();
            Iterator iterator = selectedValues.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                int index = choices.indexOf(object);
                buffer.append(this.getChoiceRenderer().getIdValue(object, index));
                buffer.append(VALUE_SEPARATOR);
            }
        }
        return buffer.toString();
    }

    protected final boolean isSelected(Object choice, int index, String selected) {
        if (selected != null) {
            StringTokenizer tokenizer = new StringTokenizer(selected, VALUE_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                if (!id.equals(this.getChoiceRenderer().getIdValue(choice, index))) continue;
                return true;
            }
        }
        return false;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("multiple", "multiple");
        if (!tag.getAttributes().containsKey("size")) {
            tag.put("size", Math.min(this.maxRows, this.getChoices().size()));
        }
    }

    protected Object convertValue(String[] ids) throws ConversionException {
        if (ids != null && ids.length > 0 && !Strings.isEmpty(ids[0])) {
            return this.convertChoiceIdsToChoices(ids);
        }
        return new ArrayList();
    }

    protected List convertChoiceIdsToChoices(String[] ids) {
        ArrayList selectedValues = new ArrayList();
        if (ids != null && ids.length > 0 && !Strings.isEmpty(ids[0])) {
            List choices = this.getChoices();
            block0: for (int i = 0; i < ids.length; ++i) {
                for (int index = 0; index < choices.size(); ++index) {
                    Object choice = choices.get(index);
                    if (!this.getChoiceRenderer().getIdValue(choice, index).equals(ids[i])) continue;
                    selectedValues.add(choice);
                    continue block0;
                }
            }
        }
        return selectedValues;
    }

    public void updateModel() {
        Collection selectedValues = (Collection)this.getModelObject();
        if (selectedValues != null) {
            this.modelChanging();
            selectedValues.clear();
            Collection converted = (Collection)this.getConvertedInput();
            if (converted != null) {
                selectedValues.addAll(converted);
            }
            this.modelChanged();
            this.getModel().setObject(selectedValues);
        } else {
            selectedValues = (Collection)this.getConvertedInput();
            this.modelChanging();
            this.getModel().setObject(selectedValues);
            this.modelChanged();
        }
    }
}

