/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.ContainerWithAssociatedMarkupHelper;
import org.apache.wicket.markup.html.HeaderPartContainer;
import org.apache.wicket.markup.html.IHeaderPartContainerProvider;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.model.IModel;

public abstract class FormComponentPanel
extends FormComponent
implements IHeaderPartContainerProvider {
    private static final long serialVersionUID = 1L;
    private ContainerWithAssociatedMarkupHelper markupHelper;
    private boolean wasOpenCloseTag = false;

    public FormComponentPanel(String id) {
        super(id);
    }

    public FormComponentPanel(String id, IModel model) {
        super(id, model);
    }

    public boolean checkRequired() {
        return true;
    }

    public HeaderPartContainer newHeaderPartContainer(String id, String scope) {
        return new HeaderPartContainer(id, this, scope);
    }

    public void renderHead(HtmlHeaderContainer container) {
        if (this.markupHelper == null) {
            this.markupHelper = new ContainerWithAssociatedMarkupHelper(this);
        }
        this.markupHelper.renderHeadFromAssociatedMarkupFile(container);
        super.renderHead(container);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (tag.isOpenClose()) {
            this.wasOpenCloseTag = true;
            tag.setType(XmlTag.OPEN);
        }
        super.onComponentTag(tag);
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.renderAssociatedMarkup("panel", "Markup for a panel component has to contain part '<wicket:panel>'");
        if (!this.wasOpenCloseTag) {
            markupStream.skipRawMarkup();
        }
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("panel");
    }
}

