/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractHeaderContributor;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;

public class HeaderContributor
extends AbstractHeaderContributor {
    private static final long serialVersionUID = 1L;
    private IHeaderContributor headerContributor = null;

    public static final HeaderContributor forCss(final Class scope, final String path) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(new CompressedResourceReference(scope, path));
            }
        });
    }

    public static final HeaderContributor forCss(final Class scope, final String path, final String media) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(new CompressedResourceReference(scope, path), media);
            }
        });
    }

    public static final HeaderContributor forCss(final ResourceReference reference) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(reference);
            }
        });
    }

    public static final HeaderContributor forCss(final ResourceReference reference, final String media) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(reference, media);
            }
        });
    }

    public static final HeaderContributor forCss(final String location) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(HeaderContributor.returnRelativePath(location));
            }
        });
    }

    public static final HeaderContributor forCss(final String location, final String media) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(HeaderContributor.returnRelativePath(location), media);
            }
        });
    }

    public static final HeaderContributor forJavaScript(final Class scope, final String path) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderJavascriptReference(new JavascriptResourceReference(scope, path));
            }
        });
    }

    public static final HeaderContributor forJavaScript(final ResourceReference reference) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderJavascriptReference(reference);
            }
        });
    }

    public static final HeaderContributor forJavaScript(final String location) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderJavascriptReference(HeaderContributor.returnRelativePath(location));
            }
        });
    }

    private static final String returnRelativePath(String location) {
        if (location.startsWith("http://") || location.startsWith("https://") || location.startsWith("/")) {
            return location;
        }
        return RequestCycle.get().getRequest().getRelativePathPrefixToContextRoot() + location;
    }

    public HeaderContributor(IHeaderContributor headerContributor) {
        if (headerContributor == null) {
            throw new IllegalArgumentException("header contributor may not be null");
        }
        this.headerContributor = headerContributor;
    }

    public final IHeaderContributor[] getHeaderContributors() {
        return new IHeaderContributor[]{this.headerContributor};
    }
}

